package com.bcxin.tenant.domain.v5.eventHandlers;

import com.bcxin.Infrastructures.components.JsonProvider;
import com.bcxin.Infrastructures.events.handlers.DomainEventHandlerAbstract;
import com.bcxin.tenant.domain.events.MemberCreatedEvent;
import com.bcxin.tenant.domain.v5.SystemConstants;
import com.bcxin.tenant.domain.v5.repositories.TDepartmentRepository;
import com.bcxin.tenant.domain.v5.services.TMcNoticeService;
import com.bcxin.tenant.domain.v5.services.TUserService;
import com.bcxin.tenant.domain.v5.services.commands.CreateMcNoticeCommand;
import com.bcxin.tenant.domain.v5.services.commands.SyncMemberCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

@Component
public class MemberCreatedEvent_V5Handler extends DomainEventHandlerAbstract<MemberCreatedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(MemberCreatedEvent_V5Handler.class);
    private final TUserService userService;
    private final TDepartmentRepository departmentRepository;

    private final TMcNoticeService mcNoticeService;
    private final JsonProvider jsonProvider;

    public MemberCreatedEvent_V5Handler(TUserService userService,
                                        TDepartmentRepository departmentRepository,
                                        TMcNoticeService mcNoticeService,
                                        JsonProvider jsonProvider) {
        this.userService = userService;
        this.departmentRepository = departmentRepository;
        this.mcNoticeService = mcNoticeService;
        this.jsonProvider = jsonProvider;
    }

    @Override
    protected void execute(MemberCreatedEvent event) {
        if(!event.isIgnoreTUser()) {
            this.userService.dispatch(new SyncMemberCommand(event.getId(), event.getOrganizationId(), event.getMemberType(),
                    event.getName(), "",
                    event.getTelephone()));
        }

        try {
            if (!CollectionUtils.isEmpty(event.getAdminIds())) {
                String content = String.format(SystemConstants.SubjectType_JoinTeamContent, event.getOrganizationName());
                Collection<CreateMcNoticeCommand.CreateMcNoticeCommandItem> items =
                        event.getAdminIds().stream().map(ii -> {
                            Map<String, String> map = new HashMap<>();
                            map.put("content", content);
                            map.put("employeeId", ii);
                            map.put("newEmployeeId", event.getId());
                            map.put("newEmployeeName", event.getName());
                            return CreateMcNoticeCommand.CreateMcNoticeCommandItem.create(
                                    ii,
                                    String.format(
                                            "<span class='notice_type' type='%s'></span><span class='notice_summary'>%s</span>",
                                            SystemConstants.SubjectType_JoinTeam,
                                            content
                                    ),
                                    "{}",
                                    event.getOrganizationId(),
                                    SystemConstants.SubjectType_JoinTeamLabel,
                                    SystemConstants.SubjectType_JoinTeam,
                                    this.jsonProvider.getJson(map)
                            );
                        }).collect(Collectors.toList());

                this.mcNoticeService.create(CreateMcNoticeCommand.create(items));
            }
        }
        catch (Exception ex) {
            //todo
            logger.error("系统异常:{}", this.jsonProvider.getJson(ex), ex);
        }
    }
}
