package com.bcxin.tenant.domain.v5.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Getter
@Setter(AccessLevel.PROTECTED)
@Table(name = "t_domain")
@Entity
public class TDomainEntity extends EntityAbstract implements IAggregate {
    @Id
    private String id;

    @Column(name = "name")
    private String name;

    @Column(name = "BIND_APPLICATIONS")
    private String bindApplication;

    @Column(name = "STATUS")
    private int status;

    @Column(name = "FIELD18")
    private String dynamic;

    public void change(String name) {
        this.setName(name);
    }

    public void changeBindApplication(String apps) {
        this.setBindApplication(apps);
    }

    public void assignDynamic(String dynamic){
        this.setDynamic(dynamic);
    }
    protected TDomainEntity(){}

    protected TDomainEntity(String id, String name) {
        this.setId(id);
        this.setName(name);
        this.setStatus(1);
    }

    public static TDomainEntity create(String id, String name) {
        return new TDomainEntity(id, name);
    }
}
