package com.bcxin.tenant.open.infrastructures.utils;

import com.bcxin.tenant.open.infrastructures.enums.PoliceEventCategory;
import com.bcxin.tenant.open.infrastructures.models.DataItemOption;

import java.util.*;
import java.util.stream.Collectors;

public class PoliceEventCategoryUtils {
    private static Collection<DataItemOption> _eventCategories = new ArrayList<>();
    static {
        _eventCategories = Arrays.stream(PoliceEventCategory.values())
                .map(ii -> {
                    DataItemOption dataItemOption = DataItemOption.create(ii.getTypeName(), ii.name());
                    switch (ii) {
                        case WWQBXX -> {
                            dataItemOption.addOption("非法组织和宗教异常活动信息", "0");
                            dataItemOption.addOption("重点人员异常活动信息", "1");
                            dataItemOption.addOption("非法聚集和游行示威信息", "2");
                            dataItemOption.addOption("涉恐信息", "3");
                            dataItemOption.addOption("反动言论、条幅、传单、标语信息", "4");
                            dataItemOption.addOption("邪教组织活动信息", "5");
                            dataItemOption.addOption("非正常上访行为预警及行动性信息", "6");
                        }
                        case ZAZXWT -> {
                            dataItemOption.addOption("违反特种行业管理问题", "0");
                            dataItemOption.addOption("烟花爆竹等危险品管理", "1");
                            dataItemOption.addOption("行业场所问题", "2");
                            dataItemOption.addOption("黑车扰序问题", "3");
                            dataItemOption.addOption("赌博问题", "4");
                            dataItemOption.addOption("卖淫嫖娼问题", "5");
                            dataItemOption.addOption("散发张贴小广告问题", "6");
                            dataItemOption.addOption("乞讨卖艺问题", "7");
                            dataItemOption.addOption("制假贩假问题", "8");
                            dataItemOption.addOption("违规养犬问题", "9");
                            dataItemOption.addOption("黄牛、号贩子问题", "10");
                        }
                        case WFFZXS -> {


                            dataItemOption.addOption("重大恶性案件线索", "0");
                            dataItemOption.addOption("侵财案件线索", "1");
                            dataItemOption.addOption("可能引发违法犯罪的其他情况", "2");
                            dataItemOption.addOption("举报在逃线索", "3");
                            dataItemOption.addOption("交易使用毒品问题", "4");
                            dataItemOption.addOption("吸食贩卖毒品", "5");
                        }
                        case QT -> {
                            dataItemOption.addOption("其他", "0");


                            dataItemOption.addOption("占道经营类", "10");
                            dataItemOption.addOption("流浪乞讨类", "11");
                            dataItemOption.addOption("噪音扰民类", "12");
                            dataItemOption.addOption("非法小广告类", "13");
                            dataItemOption.addOption("犬只未栓绳类", "14");
                            dataItemOption.addOption("污水横流类", "15");
                            dataItemOption.addOption("垃圾暴露类", "16");
                            dataItemOption.addOption("杂物占道类", "17");
                            dataItemOption.addOption("消防安全类", "18");
                            dataItemOption.addOption("建筑装修安全类", "19");
                            dataItemOption.addOption("交通安全类", "20");
                            dataItemOption.addOption("治安隐患或线索类", "21");
                            dataItemOption.addOption("刑满释放人员类", "22");
                            dataItemOption.addOption("社区矫正人员类", "23");
                            dataItemOption.addOption("易肇事肇祸等严重精神障碍患者类", "24");
                            dataItemOption.addOption("吸毒人员类", "25");
                            dataItemOption.addOption("扬言报复社会人员类", "26");
                            dataItemOption.addOption("上访人员类", "27");
                            dataItemOption.addOption("企业诉求类", "28");
                            dataItemOption.addOption("案件类", "29");
                        }
                    }


                    return dataItemOption;

                })
                .collect(Collectors.toList());
    }

    public static Collection<DataItemOption> getEventCategories() {
        return _eventCategories;
    }

    public static String getEventTypeName(PoliceEventCategory category,int typeValue) {
        if (category == null) {
            return null;
        }

        if (category == PoliceEventCategory.Sos) {
            return "一键报警";
        }

        Optional<DataItemOption> selectedOptional =
                _eventCategories.stream()
                        .filter(ii -> ii.getValue().equalsIgnoreCase(category.name()))
                        .flatMap(ii -> (ii.getChildren().stream()))
                        .filter(ii -> ii.getValue().equalsIgnoreCase(String.valueOf(typeValue)))
                        .findFirst();

        if (!selectedOptional.isPresent()) {
            return null;
        }

        return selectedOptional.get().getText();
    }
}
