package com.bcxin.tenant.open.infrastructures.enums;

import io.swagger.v3.oas.annotations.media.Schema;

@Schema(name = "TRTCActionType", title = "TRTC操作类型")
public enum TRTCActionType {

    @Schema(name = "stopWord",title = "全员禁言")
    STOPWORD{
        @Override
        public String getName(){
            return "stopWord";
        }
    },
    @Schema(name = "openWord",title = "全员解除禁言")
    OPENWORD{
        @Override
        public String getName() {
            return "openWord";
        }
    },
    /**
     * 请求开麦
     */
    @Schema(name = "handUp",title = "请求开麦")
    HANDUP {
        @Override
        public String getName() {
            return "handUp";
        }
    },
    /**
     * 申请打开视像头
     */
    @Schema(name = "cheese",title = "请求打开摄像头")
    CHEESE {
        @Override
        public String getName() {
            return "cheese";
        }
    },
    @Schema(name = "wordAllowed",title = "开麦请求允许")
    WORDALLOWED {
        @Override
        public String getName() {
            return "wordAllowed";
        }
    },
    @Schema(name = "wordDeny",title = "开麦请求拒绝")
    WORDDENY {
        @Override
        public String getName() {
            return "wordDeny";
        }
    },
    @Schema(name = "camAllowed",title = "打开摄像头请求允许")
    CAMALLOWED {
        @Override
        public String getName() {
            return "camAllowed";
        }
    },
    @Schema(name = "camDeny",title = "打开摄像头请求拒绝")
    CAMDENY {
        @Override
        public String getName() {
            return "camDeny";
        }
    },
    @Schema(name = "removeUser",title = "人员移除房间")
    REMOVEUSER{
        @Override
        public String getName() {
            return "removeUser";
        }
    },
    /**
     * 批量打开摄像头
     */
    @Schema(name = "camOn",title = "批量打开摄像头")
    CAMON {
        @Override
        public String getName() {
            return "camOn";
        }
    },
    /**
     * 批量关闭摄像头
     */
    @Schema(name = "camOff",title = "批量关闭摄像头")
    CAMOFF {
        @Override
        public String getName() {
            return "camOff";
        }
    },

    @Schema(name = "answer",title = "接听")
    ANSWER{
        @Override
        public String getName() {
            return "answer";
        }
    },
    @Schema(name = "refuse",title = "拒绝接听")
    REFUSE{
        @Override
        public String getName() {
            return "refuse";
        }
    };

    public abstract String getName();

}
