package com.bcxin.tenant.open.infrastructures.enums;

import com.bcxin.tenant.open.infrastructures.utils.BusinessUtil;
import com.bcxin.tenant.open.infrastructures.utils.StringUtil;

/**
 * 角色类型
 */
public enum RoleType {
    /**
     * 市局
     */
    Urban {
        @Override
        public String getTypeName() {
            return "市局";
        }
    },
    /**
     * 分局
     */
    SubUrb {
        @Override
        public String getTypeName() {
            return "分局";
        }
    },
    /**
     * 派出所
     */
    PoliceStation {
        @Override
        public String getTypeName() {
            return "派出所";
        }
    },
    PopulationUrban{
        @Override
        public String getTypeName() {
            return "人口市局";
        }
    },
    PopulationSubUrb{
        @Override
        public String getTypeName() {
            return "人口分局";
        }
    },
    PopulationPoliceStation {
        @Override
        public String getTypeName() {
            return "人口派出所";
        }
    },
    /**
     * 企业
     */
    Company {
        @Override
        public String getTypeName() {
            return "企业";
        }
    },

    /**
     * 内保单位;业主
     */
    Proprietor{
        @Override
        public String getTypeName() {
            return "内保单位";
        }
    };

    public abstract String getTypeName();

    public static RoleType create(String institutional, String orgName) {
        if (BusinessUtil.isSupervise(institutional)) {
            /**
             * 省市局
             */
            if (institutional.endsWith("07") || institutional.endsWith("08")) {
                if (BusinessUtil.isPopulationSupervise(institutional)) {
                    return RoleType.PopulationUrban;
                }

                return RoleType.Urban;
            }

            /**
             * 分局
             */
            if (institutional.endsWith("09")) {
                if (BusinessUtil.isPopulationSupervise(institutional)) {
                    return RoleType.PopulationSubUrb;
                }

                return RoleType.SubUrb;
            }

            /**
             * 派出所
             */
            if (institutional.endsWith("10")) {
                if (BusinessUtil.isPopulationSupervise(institutional)) {
                    return RoleType.PopulationPoliceStation;
                }

                return RoleType.PoliceStation;
            }


            /**
             * 以前旧的逻辑：按照组织名称来判断市分局调度台
             */
            if (StringUtil.isEmpty(orgName)) {
                return RoleType.PoliceStation;
            }

            if (orgName.contains("派出所")) {
                return RoleType.PoliceStation;
            }

            if ((orgName.contains("人口") || BusinessUtil.isPopulationSupervise(institutional)) && orgName.contains("分局")) {
                return RoleType.PopulationSubUrb;
            }

            if ((orgName.contains("人口") || BusinessUtil.isPopulationSupervise(institutional)) && (orgName.contains("市局") || orgName.contains("总队"))) {
                return RoleType.PopulationUrban;
            }

            if (orgName.contains("分局")) {
                return RoleType.SubUrb;
            }

            if (orgName.contains("市局") || orgName.contains("总队")) {
                return RoleType.Urban;
            }

            return RoleType.PoliceStation;
        }

        /**
         * 内保单位
         */
        if (!StringUtil.isEmpty(institutional)) {
            if (institutional.startsWith("04")) {
                return RoleType.Proprietor;
            }
        }

        return RoleType.Company;
    }

    public static boolean isSupervise(String institutional) {
        return BusinessUtil.isSupervise(institutional);
    }
}
