package com.bcxin.tenant.open.infrastructures.enums;

public enum EmploymentStatus {
    /**
     * 在职
     */
    OnJob {
        @Override
        public String getTypeName() {
            return "在职";
        }
    },
    /**
     * 离职
     */
    OffJob {
        @Override
        public String getTypeName() {
            return "离职";
        }
    },
    /**
     * 待入职
     */
    PendingForOnJob {
        @Override
        public String getTypeName() {
            return "待入职";
        }
    },
    /**
     * 申请离职中
     */
    PendingForOffJob {
        @Override
        public String getTypeName() {
            return "申请离职中";
        }
    },
    /**
     * 其他: 比如： 待岗
     */
    Other {
        @Override
        public String getTypeName() {
            return "其他";
        }
    };

    public abstract String getTypeName();
}
