package com.bcxin.tenant.open.infrastructures.enums;

import java.util.ArrayList;
import java.util.Collection;

public enum CompanyLevel {
    Basic(1<<0,"基本包"),
    Premium(1<<1,"高级包");
    int value;
    String name;

    private CompanyLevel(int value, String name) {
        this.value = value;
        this.name = name;
    }
    public static int calculate(Collection<CompanyLevel> organizationLevels) {
        int result = 0;
        if (organizationLevels != null || !organizationLevels.isEmpty()) {
            for (CompanyLevel organizationLevel : organizationLevels) {
                result |= organizationLevel.value;
            }
        }
        return result;
    }
    public static Collection<CompanyLevel> getLevels(int level) {
        Collection<CompanyLevel> result = new ArrayList<>();
        for (CompanyLevel organizationLevel1 : CompanyLevel.values()) {
            if ((level & organizationLevel1.value) > 0) {
                result.add(organizationLevel1);
            }
        }
        return result;
    }

    public static boolean contain(int organizationLevelValue, CompanyLevel level) {
        return getLevels(organizationLevelValue).contains(level);
    }
}
