package com.bcxin.tenant.open.infrastructures.components;

public class DefaultIdWorkerImpl implements IdWorker {
    private final SnowFlakeComponent component;
    public DefaultIdWorkerImpl() {
        this.component = new SnowFlakeComponent(10, 20);
    }

    @Override
    public long getNextId() {
        return this.component.getNextId();
    }

    @Override
    public long shortNextId() {
        Long id = this.getNextId();
        StringBuilder sb = new StringBuilder(id + "");
        StringBuilder reverse = sb.reverse();//将id翻转：我们发现id很长，且高位很长部分是一样的数
        id = Long.getLong(reverse.toString()) / 100000000;//切去部分长度
        while (id > 19999999) {//19999999以内的10位或9位或8位id;....
            id /= 10;
        }

        return id;
    }
}
