package com.bcxin.tenant.open.infrastructures;


import com.bcxin.tenant.open.infrastructures.exceptions.BadTenantException;
import java.util.*;

public class TenantContext {

    public static final String FLOW_TAG_NAME = "FLOW_TAG_NAME";
    public static final String PROVIDER_FLOW_TAG_NAME = "PROVIDER_FLOW_TAG_NAME";

    public static final String REST_REQUEST_FLOW_TAG_NAME = "REST_REQUEST_FLOW_TAG_NAME";

    public static final String REST_VERSION = "REST_VERSION";

    private TenantContext() {

    }

    private void init(){

    }

    private static volatile TenantContext _tenantContext;
    public static TenantContext getInstance() {
        if (_tenantContext == null) {
            synchronized (TenantContext.class) {
                if (_tenantContext == null) {
                    _tenantContext = new TenantContext();
                    _tenantContext.init();
                }
            }
        }

        return _tenantContext;
    }

    private InjectResolver injectResolver;
    public void setInjectResolver(InjectResolver injectResolver) {
        this.injectResolver = injectResolver;
    }

    public <T> T resolve(Class<T> tClass) {
        if (injectResolver == null) {
            throw new BadTenantException("InjectResolverFactory未正确初始化");
        }

        return injectResolver.resolve(tClass);
    }

    public <T> Collection<T> resolveAll(Class<T> tClass) {
        if (injectResolver == null) {
            throw new BadTenantException("InjectResolverFactory未正确初始化");
        }

        return injectResolver.resolveAll(tClass);
    }

    private static final ThreadLocal<Map<Object, Object>> attachmentsContainer = new ThreadLocal<>(){
        @Override
        protected Map<Object, Object> initialValue() {
            return new HashMap<>();
        }
    };

    public void setValue(Object key, Object value) {
        Map<Object, Object> attachments = attachmentsContainer.get();

        if(value==null)
        {
            attachments.remove(key);
        }else {
            attachments.put(key, value);
        }
        attachmentsContainer.set(attachments);
    }

    public void addAttachValues(String key,Object tagValue) {
        Map<Object, Object> attachments = attachmentsContainer.get();
        try {
            attachments.put(key, tagValue);

            attachmentsContainer.set(attachments);
        } catch (Exception ex) {
            throw new BadTenantException(String.format("添加AttachValues异常:%s", key), ex);
        }
    }

    public Object getAttachValue(String key) {
        Map<Object, Object> attachments = attachmentsContainer.get();

        return attachments.get(key);
    }

    public <T> T getValueAndRemove(Object key) {
        Map<Object, Object> attachments = attachmentsContainer.get();
        if (attachments == null) {
            return null;
        }

        T data = (T) attachments.get(key);
        this.setValue(key, null);

        return data;
    }


    private static final TenantEmployeeContext userContext = new TenantEmployeeContext();
    public TenantEmployeeContext getUserContext() {
        return userContext;
    }
}
