/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.signature.service.impl;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.signature.config.FileModeConfig;
import com.bcxin.signature.config.FileWriteConfig;
import com.bcxin.signature.entity.SignatureQueuesBazgz;
import com.bcxin.signature.entity.SignatureQueuesDocument;
import com.bcxin.signature.service.SignatureService;
import com.bcxin.signature.service.impl.SignatureServiceImpl;
import com.bcxin.signature.util.ftp.FtpUtil;
import com.bcxin.signature.util.ftp.FtpWriteUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class SignatureServiceImpl
implements SignatureService {
    private static final Logger log = LoggerFactory.getLogger(SignatureServiceImpl.class);
    @Value(value="${myapps.signature.api}")
    String api;
    @Value(value="${myapps.signature.appid}")
    String appid;
    @Value(value="${myapps.signature.sealno}")
    String sealno;
    @Value(value="${myapps.signature.license.ip_address}")
    String ip_address;
    @Value(value="${myapps.signature.license.app_key}")
    String app_key;
    @Value(value="${myapps.signature.license.app_secret}")
    String app_secret;
    @Value(value="${myapps.signature.license.account}")
    String account;
    @Value(value="${myapps.signature.license.password}")
    String password;
    private static final String STAMPFILE = "/channel/stampFile";
    private static final String FLEXIBLESEALFILE = "/channel/flexibleSealFile";
    private static final String VERIFYFILE = "/channel/verifyFile";
    private static final String DOCUMENTPATH = "/document";
    private static final String SIGNATUREATH = "/signature";
    private static final String LICENSE_LOGIN = "/license-app/v1/security/login";
    private static final String LICENSE_ISSUE = "/license-app/v1/license/{item_code}/issue?access_token=";
    private static final String LICENSE_ABOLISH = "/license-app/v1/license/{item_code}/abolish?access_token=";
    private static Map<String, Instant> tokenMap = new HashMap();
    private static int count_jtlz = 0;
    private static int count_jtlz_document = 0;
    private final ThreadPoolTaskExecutor taskExecutor;

    public SignatureServiceImpl(ThreadPoolTaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void documentSignature() {
        String ftpIn = FileModeConfig.getFilePath();
        String ftpOut = FileModeConfig.getFilePath();
        List list = FtpUtil.filenames((String)ftpIn, (String)"");
        for (String filename : list) {
            System.err.println("====> \u6587\u4e66\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1.documentSignature.filename\uff1a" + filename);
            String content = FtpUtil.getFileContent((String)ftpIn, (String)filename);
            System.err.println("====> \u6587\u4e66\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1.documentSignature.content\uff1a" + content);
            if (StringUtils.isEmpty((CharSequence)content)) continue;
            String[] arr = filename.split("-");
            if ("01".equals(arr[1])) {
                this.bazgzServer(ftpIn, ftpOut, filename, content);
                continue;
            }
            this.documentServer(ftpIn, ftpOut, filename, content, arr[1]);
        }
    }

    private void documentServer(String ftpIn, String ftpOut, String filename, String content, String type) {
        SignatureQueuesDocument document = (SignatureQueuesDocument)JSON.parseObject((String)content, SignatureQueuesDocument.class);
        System.err.println("====> \u6587\u4e66\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1.documentSignature.document\uff1a" + JSON.toJSONString((Object)document));
        if (document == null) {
            return;
        }
        document.setStatus("2");
        String[] arr = document.getFile_url().split("-");
        String baseeContent = FtpUtil.downloadAsBase64((String)ftpIn, (String)arr[1]);
        Result ret = this.verifySignature(baseeContent, document.getBusiness_name());
        if ("200".equals(Result.access$000((Result)ret))) {
            JSONObject dataJson = JSONObject.parseObject((String)JSON.toJSONString((Object)Result.access$100((Result)ret)));
            String result = dataJson.getString("result");
            if ("FALSE".equals(result)) {
                ret = this.sendSignature(document.getStamp_xy(), baseeContent, document.getBusiness_name());
                if ("200".equals(Result.access$000((Result)ret))) {
                    File file = (File)JSONObject.parseObject((String)JSON.toJSONString((Object)Result.access$100((Result)ret)), File.class);
                    try {
                        if (StringUtils.isEmpty((CharSequence)File.access$200((File)file))) {
                            throw new IOException("\u6587\u4ef6\u4e0d\u5b58\u5728");
                        }
                        FtpUtil.uploadBase64((String)ftpOut, (String)arr[1], (String)File.access$200((File)file));
                        document.setStatus("1");
                    }
                    catch (IOException e) {
                        document.setProcessed_result(e.getMessage());
                    }
                }
            } else {
                document.setStatus("1");
            }
        }
        document.setProcessed_result(ret.getMessage());
        document.setLastmodified(new Date());
        System.err.println("====> \u6587\u4e66\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1.documentSignature.document\uff1a" + JSON.toJSONString((Object)document));
        FtpUtil.uploadBase64((String)ftpOut, (String)filename.replace("IN|", "OUT|"), (String)JSON.toJSONString((Object)document));
    }

    private void bazgzServer(String ftpIn, String ftpOut, String filename, String content) {
        SignatureQueuesBazgz bazgz = (SignatureQueuesBazgz)JSON.parseObject((String)content, SignatureQueuesBazgz.class);
        System.err.println("====> \u8d44\u683c\u8bc1\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1.bazgzSignature.bazgz\uff1a" + JSON.toJSONString((Object)bazgz));
        if (bazgz == null) {
            return;
        }
        bazgz.setStatus("2");
        String[] arr = bazgz.getFile_url().split("-");
        String baseeContent = FtpUtil.downloadAsBase64((String)ftpIn, (String)arr[1]);
        Result ret = this.verifySignature(baseeContent, bazgz.getBusiness_name());
        if ("200".equals(Result.access$000((Result)ret))) {
            JSONObject dataJson = JSONObject.parseObject((String)JSON.toJSONString((Object)Result.access$100((Result)ret)));
            String result = dataJson.getString("result");
            if ("FALSE".equals(result)) {
                ret = this.sendSignature(bazgz.getStamp_xy(), baseeContent, bazgz.getBusiness_name());
                if ("200".equals(Result.access$000((Result)ret))) {
                    File file = (File)JSONObject.parseObject((String)JSON.toJSONString((Object)Result.access$100((Result)ret)), File.class);
                    try {
                        if (StringUtils.isEmpty((CharSequence)File.access$200((File)file))) {
                            throw new IOException("\u6587\u4ef6\u4e0d\u5b58\u5728");
                        }
                        FtpUtil.uploadBase64((String)ftpOut, (String)arr[1], (String)File.access$200((File)file));
                        bazgz.setStatus("1");
                    }
                    catch (IOException e) {
                        bazgz.setProcessed_result(e.getMessage());
                    }
                }
            } else {
                bazgz.setStatus("1");
            }
        }
        bazgz.setProcessed_result(ret.getMessage());
        bazgz.setLastmodified(new Date());
        System.err.println("====> \u8d44\u683c\u8bc1\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1.bazgzSignature.bazgz\uff1a" + JSON.toJSONString((Object)bazgz));
        FtpUtil.uploadBase64((String)ftpOut, (String)filename.replace("IN|", "OUT|"), (String)JSON.toJSONString((Object)bazgz));
    }

    private static void base64ToFile(String base64String, String filePath) throws IOException {
        byte[] decodedBytes = Base64.decode((String)base64String);
        Path path = Paths.get(filePath, new String[0]);
        Files.write(path, decodedBytes, new OpenOption[0]);
    }

    public void bazgzSignature() {
        String ftpIn = FileModeConfig.getFilePath();
        String ftpOut = FileModeConfig.getFilePath();
        List list = FtpUtil.filenames((String)ftpIn, (String)"");
        for (String filename : list) {
            System.err.println("====> \u8d44\u683c\u8bc1\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1.bazgzSignature.filename\uff1a" + filename);
            String content = FtpUtil.getFileContent((String)ftpIn, (String)filename);
            System.err.println("====> \u8d44\u683c\u8bc1\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1.bazgzSignature.content\uff1a" + content);
            if (StringUtils.isEmpty((CharSequence)content)) continue;
            this.bazgzServer(ftpIn, ftpOut, filename, content);
        }
    }

    public static void main(String[] args) {
    }

    public void signatureJTLZ() {
        long v = System.currentTimeMillis();
        String minuteName = DateUtil.format((Date)DateUtil.offsetMinute((Date)DateUtil.date(), (int)-5), (String)"yyyyMMddHHmm");
        String readFtpName = "INJTLZ-" + minuteName + ".bcx";
        String fileContent = FtpUtil.getFileContent((String)FileModeConfig.getFilePath(), (String)readFtpName);
        if (StringUtils.isEmpty((CharSequence)fileContent)) {
            System.err.println("====> jtlzTask.signatureJTLZ.noFile(" + FileModeConfig.getUserName() + " , " + FileModeConfig.getFilePath() + ").readFtpName\uff1a" + readFtpName);
            return;
        }
        String[] list = fileContent.split(",");
        count_jtlz = list.length;
        int count = 0;
        for (String filename : list) {
            if (count == 5) {
                count = 0;
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.taskExecutor.execute(() -> {
                long a = System.currentTimeMillis();
                try {
                    String content = FtpUtil.getFileContent((String)FileModeConfig.getFilePath(), (String)filename);
                    if (StringUtils.isEmpty((CharSequence)content)) {
                        this.jtlzNullRet(filename);
                    } else {
                        this.jtlzServer(filename, content);
                    }
                }
                catch (Exception e) {
                    this.jtlzErrRet(filename, e.getMessage());
                    System.err.println("====> jtlzTask.signatureJTLZ.jtlzServer.filename:" + filename + "\uff0cERROR\uff1a" + e.getMessage());
                }
                finally {
                    FtpUtil.delFilename((String)FileModeConfig.getFilePath(), (String)filename);
                    --count_jtlz;
                }
            });
            ++count;
        }
        for (int i = 0; count_jtlz > 0 && i != 15; ++i) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        log.info("========> jtlzTask.end.totalTime\uff1a" + (System.currentTimeMillis() - v) / 1000L + "s    ****************************");
    }

    public void signatureJTLZDocument() {
        long v = System.currentTimeMillis();
        String minuteName = DateUtil.format((Date)DateUtil.offsetMinute((Date)DateUtil.date(), (int)-5), (String)"yyyyMMddHHmm");
        String readFtpName = "INJTLZDOCUMENT-" + minuteName + ".bcx";
        String fileContent = FtpUtil.getFileContent((String)FileModeConfig.getFilePath(), (String)readFtpName);
        if (StringUtils.isEmpty((CharSequence)fileContent)) {
            System.err.println("====> jtlzDocumentTask.signatureJTLZDocument.no find file(" + FileModeConfig.getUserName() + " , " + FileModeConfig.getFilePath() + ").readFtpName\uff1a" + readFtpName);
            return;
        }
        String[] list = fileContent.split(",");
        count_jtlz_document = list.length;
        System.err.println("====> jtlzDocumentTask.signatureJTLZDocument.fileContent.splitLength\uff1a" + count_jtlz_document);
        int count = 0;
        for (String filename : list) {
            if (count == 5) {
                count = 0;
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.taskExecutor.execute(() -> {
                long a = System.currentTimeMillis();
                try {
                    String content = FtpUtil.getFileContent((String)FileModeConfig.getFilePath(), (String)filename);
                    if (StringUtils.isEmpty((CharSequence)content)) {
                        this.jtlzNullRet(filename);
                    } else {
                        this.jtlzServer(filename, content);
                    }
                }
                catch (Exception e) {
                    this.jtlzErrRet(filename, e.getMessage());
                }
                finally {
                    FtpUtil.delFilename((String)FileModeConfig.getFilePath(), (String)filename);
                    --count_jtlz_document;
                }
            });
            ++count;
        }
        for (int i = 0; count_jtlz_document > 0 && i != 15; ++i) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        log.info("========> jtlzDocumentTask.signatureJTLZDocument.end.totalTime\uff1a" + (System.currentTimeMillis() - v) / 1000L + "s    ****************************");
    }

    @Async
    public void asyncDeleteBcxFile(int start, int end) {
        DateTime now = DateUtil.date();
        for (int i = start; i <= end; ++i) {
            try {
                String[] fileList;
                DateTime offsetTime = DateUtil.offsetMinute((Date)now, (int)(-i));
                String minuteName = DateUtil.format((Date)offsetTime, (String)"yyyyMMddHHmm");
                String readFtpNameFZ = "INJTLZFZ-" + minuteName + ".bcx";
                String readFtpName = "INJTLZ-" + minuteName + ".bcx";
                String readFtpNameD = "INJTLZDOCUMENT-" + minuteName + ".bcx";
                ArrayList contents = new ArrayList();
                this.addIfNotEmpty(contents, FtpUtil.getFileContent((String)FileModeConfig.getFilePath(), (String)readFtpNameFZ));
                this.addIfNotEmpty(contents, FtpUtil.getFileContent((String)FileModeConfig.getFilePath(), (String)readFtpName));
                this.addIfNotEmpty(contents, FtpUtil.getFileContent((String)FileModeConfig.getFilePath(), (String)readFtpNameD));
                if (contents.isEmpty()) continue;
                for (String filename : fileList = String.join((CharSequence)",", contents).split(",")) {
                    boolean deleted;
                    if (!StringUtils.isNotEmpty((CharSequence)filename) || (deleted = FtpUtil.delFilename((String)FileModeConfig.getFilePath(), (String)filename))) continue;
                    System.err.println("Failed to delete file: " + filename);
                }
                continue;
            }
            catch (Exception e) {
                log.error("Error processing minute offset {}", (Object)i, (Object)e);
            }
        }
    }

    private void addIfNotEmpty(List<String> list, String content) {
        if (StringUtils.isNotEmpty((CharSequence)content)) {
            list.add(content);
        }
    }

    public void batchDeleteBcxFile() {
        int totalMinutes = 1440;
        int batchSize = 150;
        for (int i = 10; i < totalMinutes; i += batchSize) {
            int end = Math.min(i + batchSize - 1, totalMinutes);
            this.asyncDeleteBcxFile(i, end);
        }
    }

    public void signatureJTLZ_FZ() {
        long v = System.currentTimeMillis();
        String minuteName = DateUtil.format((Date)DateUtil.offsetMinute((Date)DateUtil.date(), (int)-5), (String)"yyyyMMddHHmm");
        String readFtpName = "INJTLZFZ-" + minuteName + ".bcx";
        String fileContent = FtpUtil.getFileContent((String)FileModeConfig.getFilePath(), (String)readFtpName);
        if (StringUtils.isEmpty((CharSequence)fileContent)) {
            System.err.println("====> jtlzFZTask.signatureJTLZ_FZ.no find file(" + FileModeConfig.getUserName() + " , " + FileModeConfig.getFilePath() + ").readFtpName\uff1a" + readFtpName);
            return;
        }
        String[] list = fileContent.split(",");
        int count = 0;
        for (String filename : list) {
            if (count == 5) {
                count = 0;
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.taskExecutor.execute(() -> {
                try {
                    String content = FtpUtil.getFileContent((String)FileModeConfig.getFilePath(), (String)filename);
                    if (StringUtils.isEmpty((CharSequence)content)) {
                        this.jtlzNullRet(filename);
                    } else {
                        this.jtlzFzServer(filename, content);
                    }
                }
                catch (Exception e) {
                    System.err.println("====> jtlzFZTask.signatureJTLZ_FZ.jtlzFzServer.filename:" + filename + "\uff0cERROR\uff1a" + e.getMessage());
                }
                finally {
                    FtpUtil.delFilename((String)FileModeConfig.getFilePath(), (String)filename);
                }
            });
            ++count;
        }
        long s = 59000L - (System.currentTimeMillis() - v);
        if (s > 0L) {
            try {
                Thread.sleep(s);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void jtlzNullRet(String filename) {
        String outFilename = filename.replace("IN-", "OUT-");
        String result = "{\"ack_code\":\"FAILURE\",\"errors\":[{\"code\":\"12409\",\"severity\":\"ERROR\",\"message\":\"\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u5185\u5bb9\u4e3a\u7a7a\",\"innerCode\":\"\"}],\"sign\":null,\"sign_method\":null,\"timestamp\":null,\"correlation_id\":null,\"response_id\":\"a40e028c-d566-44fc-a2fa-ee4b8df715dc\",\"data\":null}";
        FtpWriteUtil.uploadBase64((String)FileWriteConfig.getFilePath(), (String)outFilename, (String)result);
    }

    private void jtlzErrRet(String filename, String msg) {
        String outFilename = filename.replace("IN-", "OUT-");
        String result = "{\"ack_code\":\"FAILURE\",\"errors\":[{\"code\":\"12409\",\"severity\":\"ERROR\",\"message\":\"" + msg + "\",\"innerCode\":\"\"}],\"sign\":null,\"sign_method\":null,\"timestamp\":null,\"correlation_id\":null,\"response_id\":\"a40e028c-d566-44fc-a2fa-ee4b8df715dc\",\"data\":null}";
        FtpWriteUtil.uploadBase64((String)FileWriteConfig.getFilePath(), (String)outFilename, (String)result);
    }

    private void jtlzServer(String filename, String content) {
        String outFilename = filename.replace("IN-", "OUT-");
        String[] arr = filename.split("-");
        String item_code = arr[3];
        String result = this.license_issue(item_code, content);
        FtpWriteUtil.uploadBase64((String)FileWriteConfig.getFilePath(), (String)outFilename, (String)result);
    }

    private String license_issue(String item_code, String body) {
        try {
            String pathApi = this.ip_address + "/license-app/v1/license/{item_code}/issue?access_token=".replace("{item_code}", item_code) + this.getLicenseToken();
            String ret = HttpUtil.post((String)pathApi, (String)body);
            if (StringUtils.isEmpty((CharSequence)ret) || ret.contains("FAILURE")) {
                System.err.println("====> \u4eac\u901a\u9753\u8bc1\u4fe1\u606f\u63a8\u9001\u5b9a\u65f6\u4efb\u52a1.license_issue.result.err\uff1a" + ret);
            }
            return ret;
        }
        catch (Exception e) {
            System.err.println("====> \u4eac\u901a\u9753\u8bc1\u4fe1\u606f\u63a8\u9001\u5b9a\u65f6\u4efb\u52a1.license_issue.error:" + e.getMessage());
            return "{\"ack_code\":\"FAILURE\",\"errors\":[{\"code\":\"12409\",\"severity\":\"ERROR\",\"message\":\"" + e.getMessage() + "\",\"innerCode\":\"\"}],\"sign\":null,\"sign_method\":null,\"timestamp\":null,\"correlation_id\":null,\"response_id\":\"a40e028c-d566-44fc-a2fa-ee4b8df715dc\",\"data\":null}";
        }
    }

    private void jtlzFzServer(String filename, String content) {
        String outFilename = filename.replace("IN-", "OUT-");
        String[] arr = filename.split("-");
        String type = arr[2];
        String item_code = arr[3];
        String result = this.license_issue_fz(item_code, content);
        FtpWriteUtil.uploadBase64((String)FileWriteConfig.getFilePath(), (String)outFilename, (String)result);
    }

    private String license_issue_fz(String item_code, String body) {
        try {
            String pathApi = this.ip_address + "/license-app/v1/license/{item_code}/abolish?access_token=".replace("{item_code}", item_code) + this.getLicenseToken();
            String ret = HttpUtil.post((String)pathApi, (String)body);
            System.err.println("====> \u4eac\u901a\u9753\u8bc1\u4fe1\u606f\u5e9f\u6b62\u5b9a\u65f6\u4efb\u52a1.license_issue_fz.\u8fd4\u56de\u62a5\u6587\uff1a" + ret);
            return ret;
        }
        catch (Exception e) {
            System.err.println("====> \u4eac\u901a\u9753\u8bc1\u4fe1\u606f\u5e9f\u6b62\u5b9a\u65f6\u4efb\u52a1.license_issue_fz.error:" + e.getMessage());
            return "{\"ack_code\":\"FAILURE\",\"errors\":[{\"code\":\"12409\",\"severity\":\"ERROR\",\"message\":\"" + e.getMessage() + "\",\"innerCode\":\"\"}],\"sign\":null,\"sign_method\":null,\"timestamp\":null,\"correlation_id\":null,\"response_id\":\"a40e028c-d566-44fc-a2fa-ee4b8df715dc\",\"data\":null}";
        }
    }

    private String generateToken() {
        String token = "";
        try {
            JSONObject json = new JSONObject();
            json.put("app_key", (Object)this.app_key);
            json.put("app_secret", (Object)this.app_secret);
            json.put("account", (Object)this.account);
            json.put("password", (Object)this.password);
            String ret = HttpUtil.post((String)(this.ip_address + "/license-app/v1/security/login"), (String)json.toJSONString());
            if (StringUtils.isEmpty((CharSequence)ret)) {
                return token;
            }
            JSONObject result = JSONObject.parseObject((String)ret);
            String ack_code = result.getString("ack_code");
            token = result.getString("access_token");
            if (!"SUCCESS".equals(ack_code) || StringUtils.isEmpty((CharSequence)token)) {
                System.err.println("====> \u4eac\u901a\u9753\u8bc1\u83b7\u53d6token.license_login.access_token\uff1afail");
                return token;
            }
            tokenMap = new HashMap();
            tokenMap.put(token, Instant.now());
            return token;
        }
        catch (Exception e) {
            System.err.println("====> \u4eac\u901a\u9753\u8bc1\u83b7\u53d6token.license_login.error:" + e.getMessage());
            return token;
        }
    }

    private String getLicenseToken() {
        Instant now = Instant.now();
        if (tokenMap.isEmpty()) {
            return this.generateToken();
        }
        String latestToken = null;
        Instant latestTime = null;
        for (Map.Entry entry : tokenMap.entrySet()) {
            if (latestTime != null && !((Instant)entry.getValue()).isAfter(latestTime)) continue;
            latestToken = (String)entry.getKey();
            latestTime = (Instant)entry.getValue();
        }
        Duration duration = Duration.between(latestTime, now);
        if (duration.toHours() >= 6L) {
            return this.generateToken();
        }
        return latestToken;
    }

    private Result sendSignature(String stamp_xy, String baseeContent, String file_name) {
        try {
            String[] xyArr = stamp_xy.split(",");
            JSONObject json = new JSONObject();
            json.put("appId", (Object)this.appid);
            json.put("file", (Object)new File(file_name, baseeContent, "pdf", file_name + " \u7b7e\u7ae0"));
            JSONObject seal = new JSONObject();
            seal.put("sealInfo", (Object)new SealInfo(this.sealno, "FALSE"));
            JSONObject ruleInfo = new JSONObject();
            ruleInfo.put("version", (Object)"1.0");
            ruleInfo.put("ruleId", (Object)"");
            ruleInfo.put("ruleType", (Object)"RECTANGLE");
            ruleInfo.put("rectangleRule", (Object)new RectangleRule(xyArr[0], xyArr[1], xyArr[2], xyArr[3], xyArr[3]));
            seal.put("ruleInfo", (Object)ruleInfo);
            json.put("seal", (Object)seal);
            String ret = HttpUtil.post((String)(this.api + "/channel/stampFile"), (String)json.toJSONString());
            log.info("====> \u6587\u4e66\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.sendSignature.ret\uff1a" + ret);
            if (StringUtils.isEmpty((CharSequence)ret)) {
                return Result.fail((String)"\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25\uff1a\u8fd4\u56de\u7a7a");
            }
            return (Result)JSON.parseObject((String)ret, Result.class);
        }
        catch (Exception e) {
            log.info("====> \u7b7e\u7ae0\u4e1a\u52a1\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.sendSignature message:" + e.getMessage());
            return Result.fail((String)("\u63a5\u53e3\u8bf7\u6c42\u5f02\u5e38\uff1a" + e.getMessage()));
        }
    }

    private Result verifySignature(String baseeContent, String file_name) {
        try {
            JSONObject json = new JSONObject();
            json.put("appId", (Object)this.appid);
            json.put("file", (Object)new File(file_name, baseeContent, "pdf", file_name + " \u7b7e\u7ae0"));
            String ret = HttpUtil.post((String)(this.api + "/channel/verifyFile"), (String)json.toJSONString());
            log.info("====> \u6587\u4e66\u9a8c\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.verifySignature.ret\uff1a" + ret);
            if (StringUtils.isEmpty((CharSequence)ret)) {
                return Result.fail((String)"\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25\uff1a\u8fd4\u56de\u7a7a");
            }
            return (Result)JSON.parseObject((String)ret, Result.class);
        }
        catch (Exception e) {
            log.info("====> \u6587\u4e66\u9a8c\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.verifySignature message:" + e.getMessage());
            return Result.fail((String)("\u63a5\u53e3\u8bf7\u6c42\u5f02\u5e38\uff1a" + e.getMessage()));
        }
    }
}

