package com.bcxin.backend.tasks;

import com.bcxin.backend.domain.signature.common.QzConstant;
import com.bcxin.backend.domain.signature.service.BeiJingInDocumentSignature;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * 初始生成文书签章数据，每5分钟检索一次
 */
@Component
public class SignatureDocumentInitTask extends TaskAbstract{

    @Value("${myapps.signature.serverKey}")
    String serverKey;
    private final BeiJingInDocumentSignature beiJingInDocumentSignature;

    public SignatureDocumentInitTask(BeiJingInDocumentSignature beiJingInDocumentSignature) {
        this.beiJingInDocumentSignature = beiJingInDocumentSignature;
    }


    @Override
    protected void runCore() {
        if(QzConstant.QZ_SIGNATURE_SERVER_KEY_BEIJINGIN.equals(serverKey)){
            //北京内网文书签章初始化数据
            beiJingInDocumentSignature.initDocumentSignature();
        }
    }

    @Override
    public String getTaskName() {
        return "execute.signature.pdf.document.init";
    }

}
