package com.bcxin.backend;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.core.env.Environment;

@EnableCaching
@SpringBootApplication(scanBasePackages = {"com.bcxin.backend.domain","com.bcxin.backend"})
public class BackendApp {

    private static final Logger log = LoggerFactory.getLogger(BackendApp.class);
    public static void main(String[] args) {

        try {
            SpringApplication app = new SpringApplication(BackendApp.class);
            Environment env = app.run(args).getEnvironment();
            log.info("\n----------------------------------------------------------\n\t" +
                            "Application '{}' is running! Access URLs:\n\t" +
                            "Local: \t\thttp://localhost:{}\n\t" +
                            "----------------------------------------------------------",
                    env.getProperty("spring.application.name"),
                    env.getProperty("server.port"));

            String[] activeProfiles = env.getActiveProfiles();
            log.error("启动的配置文件为：{}", JSON.toJSONString(activeProfiles));
        }
        catch (Exception ex){
            ex.printStackTrace();
        }
    }
}
