package com.bcxin.backend.domain.enums;

public enum HnCertCatalog {
    /*
     * 证书模板参数
     * catalogId:分类id
     * templateId:模板id
     * templateName:模板名称
     * version:版本号
     */
    C430100("长沙", "2d79ecfac3e64b6d86912121538f08b6", "保安员证", "c03b6f3cb73f4a459bf20f5856683bb1", "保安员证模板", "2018V1.0","长沙市公安局"),
    C430400("衡阳", "9d036a7a4cfe45c190ef5fdc08989251", "保安员证", "54acf788cfc0466cb7b9422b8213f57f", "保安员证模板", "2018V1.0","衡阳市公安局"),
    C430200("株洲", "f88e218370f1436a9649a177f87d4408", "保安员证", "5414a9fb5ffe4b19ba0e05ec6bd7b641", "保安员证模板", "2018V1.0","株洲市公安局"),
    C430300("湘潭", "ff5ec8e3dbc648dfb89c6abc37885072", "保安员证", "991274d9a2f54068a91cf6bb14e310f1", "保安员证模板", "2018V1.0","湘潭市公安局"),
    C430500("邵阳", "29abb08f027c43858a5d6ab8f8fd6cdb", "保安员证", "2f555cc48f634c96b67b325d2e22151c", "保安员证模板", "2018V1.0","邵阳市公安局"),
    C430600("岳阳", "5a11b7230005439bb0be39e8ceccdb40", "保安员证", "14aa841375424d2080be54760ed2d6e5", "保安员证模板", "2018V1.0","岳阳市公安局"),
    C430700("常德", "31e4e2a4d4cb485a848b1765ea5bb268", "保安员证", "745f9b64101a45b8bca29d0960189abc", "保安员证模板", "2018V1.0","常德市公安局"),
    C430800("张家界", "196848ec78e5438eafe5d9195ebcb1d5", "保安员证", "912013fc72964fc8b53fc8a3ed5dfb4f", "保安员证模板", "2018V1.0","张家界市公安局"),
    C430900("益阳", "75406ff36ea74bc3a6eeafafb4b931dd", "保安员证", "1d332ec4b96a447f830e9cfb9548dbd0", "保安员证模板", "2018V1.0","益阳市公安局"),
    C431000("郴州", "c8077a891a1b40a08a5a9486728634f7", "保安员证", "88ec0281cde542ec97bb9ec2a39bc755", "保安员证模板", "2018V1.0","郴州市公安局"),
    C431100("永州", "77b31ec023694876a9007ad23220e9bc", "保安员证", "87e52258dd25441dae5ba317f3eb9a3a", "保安员证模板", "2018V1.0","永州市公安局"),
    C432000("怀化", "af74f994ed3642449071460949b8ad4d", "保安员证", "8a242034bb194a5cb344a2d36b28fd53", "保安员证模板", "2018V1.0","怀化市公安局"),
    C431300("娄底", "aea78ad3e29741c9a264d291376239ba", "保安员证", "a89405164ace4baebc3c4c1d1835a186", "保安员证模板", "2018V1.0","娄底市公安局"),
    C431400("湘西", "07adeae13e324be9bb229a4505ae1813", "保安员证", "3f8f46f34232497e86bb64cd0e5014cc", "保安员证模板", "2018V1.0","湘西土家族苗族自治州公安局");
    private final String areaName;
    private final String catalogId;
    private final String catalogName;
    private final String templateId;
    private final String templateName;
    private final String version;
    private final String issueUnitname;

    HnCertCatalog(String areaName, String catalogId, String catalogName, String templateId, String templateName, String version, String issueUnitname) {
        this.areaName = areaName;
        this.catalogId = catalogId;
        this.catalogName = catalogName;
        this.templateId = templateId;
        this.templateName = templateName;
        this.version = version;
        this.issueUnitname = issueUnitname;
    }

    public String getAreaName() {
        return this.areaName;
    }

    public String getCatalogId() {
        return catalogId;
    }

    public String getCatalogName() {
        return catalogName;
    }

    public String getTemplateId() {
        return templateId;
    }

    public String getTemplateName() {
        return templateName;
    }

    public String getVersion() {
        return version;
    }

    public String getIssueUnitname() {
        return issueUnitname;
    }

    public static HnCertCatalog getByAreaName(String areaName) {
        for (HnCertCatalog sxCertDn : HnCertCatalog.values()) {
            if (areaName.contains(sxCertDn.getAreaName())) {
                return sxCertDn;
            }
        }
        return null;
    }

    public static void main(String[] args) {
        System.out.println(HnCertCatalog.getByAreaName("长沙市公安局"));
    }
}
