/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.signature.config.exception;

import com.bcxin.signature.config.exception.BusinessException;
import com.bcxin.signature.util.Result;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

/*
 * Exception performing whole class analysis ignored.
 */
@ControllerAdvice
public class ExceptionInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ExceptionInterceptor.class);

    @ExceptionHandler(value={Exception.class})
    public Result handlerException(Exception ex, HttpServletRequest request) {
        if (ex instanceof BusinessException) {
            BusinessException be = (BusinessException)ex;
            log.warn("\u672c\u6b21\u4e1a\u52a1\u5f02\u5e38\u7f16\u7801\uff1a" + be.getCode() + "\uff0c\u4e1a\u52a1\u5f02\u5e38\u6d88\u606f\uff1a" + be.getMsg(), (Throwable)be);
            return Result.fail((HttpServletRequest)request, (String)be.getMsg(), null);
        }
        String exception = ExceptionInterceptor.toString((Throwable)ex);
        if (exception.length() > 3000) {
            exception = exception.substring(0, 3000);
        }
        log.error("\u5168\u5c40\u5f02\u5e38\u6355\u83b7>>>>>>>>>>>>", (Throwable)ex);
        return Result.fail((HttpServletRequest)request, (String)ex.getMessage(), null);
    }

    private static String toString(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        e.printStackTrace(pw);
        pw.flush();
        sw.flush();
        return sw.toString();
    }
}

