/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.signature.service.impl;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.backend.core.edis.EDIConstants;
import com.bcxin.signature.components.JTLZPendingQueueComponent;
import com.bcxin.signature.components.JTLZPushComponent;
import com.bcxin.signature.config.FileModeConfig;
import com.bcxin.signature.config.FileWriteConfig;
import com.bcxin.signature.entity.SignatureQueuesBazgz;
import com.bcxin.signature.entity.SignatureQueuesDocument;
import com.bcxin.signature.service.SignatureService;
import com.bcxin.signature.service.impl.SignatureServiceImpl;
import com.bcxin.signature.util.ftp.FtpConnection;
import com.bcxin.signature.util.ftp.FtpUtil;
import com.bcxin.signature.util.ftp.FtpWriteConnection;
import com.bcxin.signature.util.ftp.FtpWriteUtil;
import com.bcxin.signature.util.ftp.ThreadFtpContext;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class SignatureServiceImpl
implements SignatureService {
    private static final Logger log = LoggerFactory.getLogger(SignatureServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(SignatureServiceImpl.class);
    @Value(value="${myapps.signature.api}")
    String api;
    @Value(value="${myapps.signature.appid}")
    String appid;
    @Value(value="${myapps.signature.sealno}")
    String sealno;
    @Value(value="${myapps.signature.license.ip_address}")
    String ip_address;
    @Value(value="${myapps.signature.license.app_key}")
    String app_key;
    @Value(value="${myapps.signature.license.app_secret}")
    String app_secret;
    @Value(value="${myapps.signature.license.account}")
    String account;
    @Value(value="${myapps.signature.license.password}")
    String password;
    private static final String STAMPFILE = "/channel/stampFile";
    private static final String FLEXIBLESEALFILE = "/channel/flexibleSealFile";
    private static final String VERIFYFILE = "/channel/verifyFile";
    private static final String DOCUMENTPATH = "/document";
    private static final String SIGNATUREATH = "/signature";
    private static final String LICENSE_LOGIN = "/license-app/v1/security/login";
    private static final String LICENSE_ISSUE = "/license-app/v1/license/{item_code}/issue?access_token=";
    private static final String LICENSE_ABOLISH = "/license-app/v1/license/{item_code}/abolish?access_token=";
    private static Map<String, Instant> tokenMap = new HashMap();
    private static int count_jtlz_document = 0;
    private final ThreadPoolTaskExecutor taskExecutor;
    private final JTLZPushComponent jtlzPushComponent;
    private final JTLZPendingQueueComponent pendingQueueComponent;

    public SignatureServiceImpl(ThreadPoolTaskExecutor taskExecutor, JTLZPushComponent jtlzPushComponent, JTLZPendingQueueComponent pendingQueueComponent) {
        this.taskExecutor = taskExecutor;
        this.jtlzPushComponent = jtlzPushComponent;
        this.pendingQueueComponent = pendingQueueComponent;
    }

    public void documentSignature() {
        String ftpIn = FileModeConfig.getFilePath();
        String ftpOut = FileModeConfig.getFilePath();
        List list = FtpUtil.filenames((String)ftpIn, (String)"");
        for (String filename : list) {
            System.err.println("====> \u6587\u4e66\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1.documentSignature.filename\uff1a" + filename);
            String content = FtpUtil.getFileContent((String)ftpIn, (String)filename);
            System.err.println("====> \u6587\u4e66\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1.documentSignature.content\uff1a" + content);
            if (StringUtils.isEmpty((CharSequence)content)) continue;
            String[] arr = filename.split("-");
            if ("01".equals(arr[1])) {
                this.bazgzServer(ftpIn, ftpOut, filename, content);
                continue;
            }
            this.documentServer(ftpIn, ftpOut, filename, content, arr[1]);
        }
    }

    private void documentServer(String ftpIn, String ftpOut, String filename, String content, String type) {
        SignatureQueuesDocument document = (SignatureQueuesDocument)JSON.parseObject((String)content, SignatureQueuesDocument.class);
        System.err.println("====> \u6587\u4e66\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1.documentSignature.document\uff1a" + JSON.toJSONString((Object)document));
        if (document == null) {
            return;
        }
        document.setStatus("2");
        String[] arr = document.getFile_url().split("-");
        String baseeContent = FtpUtil.downloadAsBase64((String)ftpIn, (String)arr[1]);
        Result ret = this.verifySignature(baseeContent, document.getBusiness_name());
        if ("200".equals(Result.access$000((Result)ret))) {
            JSONObject dataJson = JSONObject.parseObject((String)JSON.toJSONString((Object)Result.access$100((Result)ret)));
            String result = dataJson.getString("result");
            if ("FALSE".equals(result)) {
                ret = this.sendSignature(document.getStamp_xy(), baseeContent, document.getBusiness_name());
                if ("200".equals(Result.access$000((Result)ret))) {
                    File file = (File)JSONObject.parseObject((String)JSON.toJSONString((Object)Result.access$100((Result)ret)), File.class);
                    try {
                        if (StringUtils.isEmpty((CharSequence)File.access$200((File)file))) {
                            throw new IOException("\u6587\u4ef6\u4e0d\u5b58\u5728");
                        }
                        FtpUtil.uploadBase64((String)ftpOut, (String)arr[1], (String)File.access$200((File)file));
                        document.setStatus("1");
                    }
                    catch (IOException e) {
                        document.setProcessed_result(e.getMessage());
                    }
                }
            } else {
                document.setStatus("1");
            }
        }
        document.setProcessed_result(ret.getMessage());
        document.setLastmodified(new Date());
        System.err.println("====> \u6587\u4e66\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1.documentSignature.document\uff1a" + JSON.toJSONString((Object)document));
        FtpUtil.uploadBase64((String)ftpOut, (String)filename.replace("IN|", "OUT|"), (String)JSON.toJSONString((Object)document));
    }

    private void bazgzServer(String ftpIn, String ftpOut, String filename, String content) {
        SignatureQueuesBazgz bazgz = (SignatureQueuesBazgz)JSON.parseObject((String)content, SignatureQueuesBazgz.class);
        System.err.println("====> \u8d44\u683c\u8bc1\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1.bazgzSignature.bazgz\uff1a" + JSON.toJSONString((Object)bazgz));
        if (bazgz == null) {
            return;
        }
        bazgz.setStatus("2");
        String[] arr = bazgz.getFile_url().split("-");
        String baseeContent = FtpUtil.downloadAsBase64((String)ftpIn, (String)arr[1]);
        Result ret = this.verifySignature(baseeContent, bazgz.getBusiness_name());
        if ("200".equals(Result.access$000((Result)ret))) {
            JSONObject dataJson = JSONObject.parseObject((String)JSON.toJSONString((Object)Result.access$100((Result)ret)));
            String result = dataJson.getString("result");
            if ("FALSE".equals(result)) {
                ret = this.sendSignature(bazgz.getStamp_xy(), baseeContent, bazgz.getBusiness_name());
                if ("200".equals(Result.access$000((Result)ret))) {
                    File file = (File)JSONObject.parseObject((String)JSON.toJSONString((Object)Result.access$100((Result)ret)), File.class);
                    try {
                        if (StringUtils.isEmpty((CharSequence)File.access$200((File)file))) {
                            throw new IOException("\u6587\u4ef6\u4e0d\u5b58\u5728");
                        }
                        FtpUtil.uploadBase64((String)ftpOut, (String)arr[1], (String)File.access$200((File)file));
                        bazgz.setStatus("1");
                    }
                    catch (IOException e) {
                        bazgz.setProcessed_result(e.getMessage());
                    }
                }
            } else {
                bazgz.setStatus("1");
            }
        }
        bazgz.setProcessed_result(ret.getMessage());
        bazgz.setLastmodified(new Date());
        System.err.println("====> \u8d44\u683c\u8bc1\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1.bazgzSignature.bazgz\uff1a" + JSON.toJSONString((Object)bazgz));
        FtpUtil.uploadBase64((String)ftpOut, (String)filename.replace("IN|", "OUT|"), (String)JSON.toJSONString((Object)bazgz));
    }

    private static void base64ToFile(String base64String, String filePath) throws IOException {
        byte[] decodedBytes = Base64.decode((String)base64String);
        Path path = Paths.get(filePath, new String[0]);
        Files.write(path, decodedBytes, new OpenOption[0]);
    }

    public void bazgzSignature() {
        String ftpIn = FileModeConfig.getFilePath();
        String ftpOut = FileModeConfig.getFilePath();
        List list = FtpUtil.filenames((String)ftpIn, (String)"");
        for (String filename : list) {
            System.err.println("====> \u8d44\u683c\u8bc1\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1.bazgzSignature.filename\uff1a" + filename);
            String content = FtpUtil.getFileContent((String)ftpIn, (String)filename);
            System.err.println("====> \u8d44\u683c\u8bc1\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1.bazgzSignature.content\uff1a" + content);
            if (StringUtils.isEmpty((CharSequence)content)) continue;
            this.bazgzServer(ftpIn, ftpOut, filename, content);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signatureJTLZ() {
        logger.error("executing signatureJTLZ...");
        FtpConnection topFtp = ThreadFtpContext.getFtpConnection();
        String traceId = UUID.randomUUID().toString();
        Collection pendingFileNames = null;
        StopWatch metaStopWatch = new StopWatch();
        Exception topException = null;
        try {
            metaStopWatch.start();
            pendingFileNames = FtpUtil.getFtpMetaFiles((FtpConnection)topFtp);
        }
        catch (Exception ex) {
            try {
                topException = ex;
            }
            catch (Throwable throwable) {
                metaStopWatch.stop();
                logger.error("{} geting pending files:{}; cost {} seconds", new Object[]{traceId, pendingFileNames == null ? "EMPTY" : Integer.valueOf(pendingFileNames.size()), metaStopWatch.getTotalTimeSeconds(), topException});
                throw throwable;
            }
            metaStopWatch.stop();
            logger.error("{} geting pending files:{}; cost {} seconds", new Object[]{traceId, pendingFileNames == null ? "EMPTY" : Integer.valueOf(pendingFileNames.size()), metaStopWatch.getTotalTimeSeconds(), topException});
        }
        metaStopWatch.stop();
        logger.error("{} geting pending files:{}; cost {} seconds", new Object[]{traceId, pendingFileNames == null ? "EMPTY" : Integer.valueOf(pendingFileNames.size()), metaStopWatch.getTotalTimeSeconds(), topException});
        if (!CollectionUtils.isEmpty((Collection)pendingFileNames)) {
            // empty if block
        }
        Collection directlyFiles = this.pendingQueueComponent.getPendingContentFiles("IN-JTLZ-");
        Exception exception = null;
        StopWatch watch = new StopWatch();
        watch.start();
        try {
            this.jtlzPushComponent.execute(traceId, directlyFiles.toArray(new String[directlyFiles.size()]), false);
        }
        catch (Exception ex) {
            try {
                exception = ex;
            }
            catch (Throwable throwable) {
                watch.stop();
                logger.error("{}-Done for directly execute cost {} seconds[pendingFileNames={}] size={}", new Object[]{exception == null ? "SUCCESS" : "ERROR", watch.getTotalTimeSeconds(), CollectionUtils.isEmpty((Collection)pendingFileNames) ? "Empty" : pendingFileNames.stream().collect(Collectors.joining(",")), directlyFiles == null ? "EMPTY" : Integer.valueOf(directlyFiles.size()), exception});
                throw throwable;
            }
            watch.stop();
            logger.error("{}-Done for directly execute cost {} seconds[pendingFileNames={}] size={}", new Object[]{exception == null ? "SUCCESS" : "ERROR", watch.getTotalTimeSeconds(), CollectionUtils.isEmpty((Collection)pendingFileNames) ? "Empty" : pendingFileNames.stream().collect(Collectors.joining(",")), directlyFiles == null ? "EMPTY" : Integer.valueOf(directlyFiles.size()), exception});
        }
        watch.stop();
        logger.error("{}-Done for directly execute cost {} seconds[pendingFileNames={}] size={}", new Object[]{exception == null ? "SUCCESS" : "ERROR", watch.getTotalTimeSeconds(), CollectionUtils.isEmpty((Collection)pendingFileNames) ? "Empty" : pendingFileNames.stream().collect(Collectors.joining(",")), directlyFiles == null ? "EMPTY" : Integer.valueOf(directlyFiles.size()), exception});
        if (CollectionUtils.isEmpty((Collection)pendingFileNames)) {
            return;
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        boolean isEmpty = false;
        logger.error("{} prepare to process the pendingFileNames:{}", new Object[]{traceId, isEmpty, pendingFileNames.size()});
        Exception lastException = null;
        try {
            List<CompletableFuture> resultFutures = pendingFileNames.stream().map(rfn -> CompletableFuture.runAsync(() -> this.jtlzPushComponent.execute(traceId, rfn), (Executor)this.taskExecutor)).collect(Collectors.toList());
            Void rt = CompletableFuture.allOf(resultFutures.toArray(new CompletableFuture[resultFutures.size()])).join();
            logger.error("success:{}", (Object)rt);
        }
        catch (Exception ex) {
            try {
                lastException = ex;
            }
            catch (Throwable throwable) {
                stopWatch.stop();
                log.error("{}-({}) Done for signatureJTLZ cost {} seconds - pendingFileSize={}", new Object[]{traceId, lastException == null ? "SUCCESS" : "ERROR", stopWatch.getTotalTimeSeconds(), pendingFileNames.size()});
                throw throwable;
            }
            stopWatch.stop();
            log.error("{}-({}) Done for signatureJTLZ cost {} seconds - pendingFileSize={}", new Object[]{traceId, lastException == null ? "SUCCESS" : "ERROR", stopWatch.getTotalTimeSeconds(), pendingFileNames.size()});
        }
        stopWatch.stop();
        log.error("{}-({}) Done for signatureJTLZ cost {} seconds - pendingFileSize={}", new Object[]{traceId, lastException == null ? "SUCCESS" : "ERROR", stopWatch.getTotalTimeSeconds(), pendingFileNames.size()});
    }

    public void signatureJTLZDocument() {
        Collection directlyFiles = this.pendingQueueComponent.getPendingContentFiles("IN-JTLZ-15-");
    }

    @Async
    public void asyncDeleteBcxFile(int start, int end) {
        DateTime now = DateUtil.date();
        for (int i = start; i <= end; ++i) {
            try {
                String[] fileList;
                DateTime offsetTime = DateUtil.offsetMinute((Date)now, (int)(-i));
                String minuteName = DateUtil.format((Date)offsetTime, (String)"yyyyMMddHHmm");
                String readFtpNameFZ = "INJTLZFZ-" + minuteName + ".bcx";
                String readFtpName = "INJTLZ-" + minuteName + ".bcx";
                String readFtpNameD = "INJTLZDOCUMENT-" + minuteName + ".bcx";
                ArrayList contents = new ArrayList();
                this.addIfNotEmpty(contents, FtpUtil.getFileContent((String)FileModeConfig.getFilePath(), (String)readFtpNameFZ));
                this.addIfNotEmpty(contents, FtpUtil.getFileContent((String)FileModeConfig.getFilePath(), (String)readFtpName));
                this.addIfNotEmpty(contents, FtpUtil.getFileContent((String)FileModeConfig.getFilePath(), (String)readFtpNameD));
                if (contents.isEmpty()) continue;
                for (String filename : fileList = String.join((CharSequence)",", contents).split(",")) {
                    boolean deleted;
                    if (!StringUtils.isNotEmpty((CharSequence)filename) || (deleted = FtpUtil.delFilename((String)FileModeConfig.getFilePath(), (String)filename))) continue;
                    System.err.println("Failed to delete file: " + filename);
                }
                continue;
            }
            catch (Exception e) {
                log.error("Error processing minute offset {}", (Object)i, (Object)e);
            }
        }
    }

    private void addIfNotEmpty(List<String> list, String content) {
        if (StringUtils.isNotEmpty((CharSequence)content)) {
            list.add(content);
        }
    }

    public void batchDeleteBcxFile() {
        int totalMinutes = 1440;
        int batchSize = 150;
        for (int i = 10; i < totalMinutes; i += batchSize) {
            int end = Math.min(i + batchSize - 1, totalMinutes);
            this.asyncDeleteBcxFile(i, end);
        }
    }

    public void signatureJTLZ_FZ() {
        long v = System.currentTimeMillis();
        String minuteName = DateUtil.format((Date)DateUtil.offsetMinute((Date)DateUtil.date(), (int)-5), (String)"yyyyMMddHHmm");
        String readFtpName = "INJTLZFZ-" + minuteName + ".bcx";
        String fileContent = FtpUtil.getFileContent((String)FileModeConfig.getFilePath(), (String)readFtpName);
        if (StringUtils.isEmpty((CharSequence)fileContent)) {
            logger.error("====> jtlzFZTask.signatureJTLZ_FZ.no find file(" + FileModeConfig.getUserName() + " , " + FileModeConfig.getFilePath() + ").readFtpName\uff1a" + readFtpName);
            return;
        }
        String[] list = fileContent.split(",");
        int count = 0;
        for (String filename : list) {
            if (count == 5) {
                count = 0;
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.taskExecutor.execute(() -> {
                try {
                    String content = FtpUtil.getFileContent((String)FileModeConfig.getFilePath(), (String)filename);
                    if (StringUtils.isEmpty((CharSequence)content)) {
                        this.jtlzNullRet(filename);
                    } else {
                        this.jtlzFzServer(filename, content);
                    }
                }
                catch (Exception e) {
                    System.err.println("====> jtlzFZTask.signatureJTLZ_FZ.jtlzFzServer.filename:" + filename + "\uff0cERROR\uff1a" + e.getMessage());
                }
                finally {
                    FtpUtil.delFilename((String)FileModeConfig.getFilePath(), (String)filename);
                }
            });
            ++count;
        }
        long s = 59000L - (System.currentTimeMillis() - v);
        if (s > 0L) {
            try {
                Thread.sleep(s);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void jtlzNullRet(String filename) {
        String outFilename = filename.replace("IN-", "OUT-");
        String result = "{\"ack_code\":\"FAILURE\",\"errors\":[{\"code\":\"12409\",\"severity\":\"ERROR\",\"message\":\"\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u5185\u5bb9\u4e3a\u7a7a\",\"innerCode\":\"\"}],\"sign\":null,\"sign_method\":null,\"timestamp\":null,\"correlation_id\":null,\"response_id\":\"a40e028c-d566-44fc-a2fa-ee4b8df715dc\",\"data\":null}";
        FtpWriteUtil.uploadBase64((String)FileWriteConfig.getFilePath(), (String)outFilename, (String)result);
    }

    private void jtlzErrRet(String filename, String msg) {
        String outFilename = filename.replace("IN-", "OUT-");
        String result = "{\"ack_code\":\"FAILURE\",\"errors\":[{\"code\":\"12409\",\"severity\":\"ERROR\",\"message\":\"" + msg + "\",\"innerCode\":\"\"}],\"sign\":null,\"sign_method\":null,\"timestamp\":null,\"correlation_id\":null,\"response_id\":\"a40e028c-d566-44fc-a2fa-ee4b8df715dc\",\"data\":null}";
        FtpWriteUtil.uploadBase64((String)FileWriteConfig.getFilePath(), (String)outFilename, (String)result);
    }

    private void jtlzServer(String filename, String content) {
        String outFilename = filename.replace("IN-", "OUT-");
        String[] arr = filename.split("-");
        String item_code = arr[3];
        String result = this.license_issue(item_code, content);
        FtpWriteConnection ftpWriteConnection = ThreadFtpContext.getFtpWriteConnection();
        FtpWriteUtil.uploadBase64((FtpWriteConnection)ftpWriteConnection, (String)FileWriteConfig.getFilePath(), (String)outFilename, (String)result);
    }

    private String license_issue(String item_code, String body) {
        try {
            String token = this.getLicenseToken();
            String pathApi = this.ip_address + "/license-app/v1/license/{item_code}/issue?access_token=".replace("{item_code}", item_code) + token;
            String ret = HttpUtil.post((String)pathApi, (String)body);
            if (EDIConstants.isPushError((String)ret)) {
                logger.error("====> 1.fail to JTLZ schedule task job.license_issue.result.err\uff1a(item_code={},pathAPI={}); ret = {}", new Object[]{item_code, pathApi, ret});
            }
            return ret;
        }
        catch (Exception e) {
            logger.error("====> 2.fail to JTLZ schedule task job.license_issue.err\uff1a}", (Throwable)e);
            return "{\"ack_code\":\"FAILURE\",\"errors\":[{\"code\":\"12409\",\"severity\":\"ERROR\",\"message\":\"" + e.getMessage() + "\",\"innerCode\":\"\"}],\"sign\":null,\"sign_method\":null,\"timestamp\":null,\"correlation_id\":null,\"response_id\":\"a40e028c-d566-44fc-a2fa-ee4b8df715dc\",\"data\":null}";
        }
    }

    private void jtlzFzServer(String filename, String content) {
        String outFilename = filename.replace("IN-", "OUT-");
        String[] arr = filename.split("-");
        String type = arr[2];
        String item_code = arr[3];
        String result = this.license_issue_fz(item_code, content);
        FtpWriteUtil.uploadBase64((String)FileWriteConfig.getFilePath(), (String)outFilename, (String)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String license_issue_fz(String item_code, String body) {
        String string;
        Exception lastException = null;
        String ret = null;
        String pathApi = null;
        try {
            pathApi = this.ip_address + "/license-app/v1/license/{item_code}/abolish?access_token=".replace("{item_code}", item_code) + this.getLicenseToken();
            string = ret = HttpUtil.post((String)pathApi, (String)body);
        }
        catch (Exception e) {
            String string2;
            try {
                lastException = e;
                string2 = "{\"ack_code\":\"FAILURE\",\"errors\":[{\"code\":\"12409\",\"severity\":\"ERROR\",\"message\":\"" + e.getMessage() + "\",\"innerCode\":\"\"}],\"sign\":null,\"sign_method\":null,\"timestamp\":null,\"correlation_id\":null,\"response_id\":\"a40e028c-d566-44fc-a2fa-ee4b8df715dc\",\"data\":null}";
            }
            catch (Throwable throwable) {
                logger.error("===> {} \u4eac\u901a\u9753\u8bc1\u4fe1\u606f\u5e9f\u6b62\u5b9a\u65f6\u4efb\u52a1.license_issue_fz.\u8fd4\u56de\u62a5\u6587(api=>{},body={}):{}", new Object[]{lastException == null ? "\u6210\u529f" : "\u5f02\u5e38", pathApi, body, ret, lastException});
                throw throwable;
            }
            logger.error("===> {} \u4eac\u901a\u9753\u8bc1\u4fe1\u606f\u5e9f\u6b62\u5b9a\u65f6\u4efb\u52a1.license_issue_fz.\u8fd4\u56de\u62a5\u6587(api=>{},body={}):{}", new Object[]{lastException == null ? "\u6210\u529f" : "\u5f02\u5e38", pathApi, body, ret, lastException});
            return string2;
        }
        logger.error("===> {} \u4eac\u901a\u9753\u8bc1\u4fe1\u606f\u5e9f\u6b62\u5b9a\u65f6\u4efb\u52a1.license_issue_fz.\u8fd4\u56de\u62a5\u6587(api=>{},body={}):{}", new Object[]{lastException == null ? "\u6210\u529f" : "\u5f02\u5e38", pathApi, body, ret, lastException});
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateToken() {
        String string;
        String token;
        Exception lastException;
        StopWatch stopWatch;
        block7: {
            String ret;
            block6: {
                stopWatch = new StopWatch();
                stopWatch.start();
                lastException = null;
                token = "";
                JSONObject json = new JSONObject();
                json.put("app_key", (Object)this.app_key);
                json.put("app_secret", (Object)this.app_secret);
                json.put("account", (Object)this.account);
                json.put("password", (Object)this.password);
                ret = HttpUtil.post((String)(this.ip_address + "/license-app/v1/security/login"), (String)json.toJSONString());
                if (!StringUtils.isEmpty((CharSequence)ret)) break block6;
                String string2 = token;
                stopWatch.stop();
                logger.error("====> {} \u4eac\u901a\u9753\u8bc1\u83b7\u53d6token.license_login. \u8017\u65f6 {} \u79d2", new Object[]{lastException == null ? "\u6210\u529f" : "\u5f02\u5e38", lastException, stopWatch.getTotalTimeSeconds()});
                return string2;
            }
            JSONObject result = JSONObject.parseObject((String)ret);
            String ack_code = result.getString("ack_code");
            token = result.getString("access_token");
            if ("SUCCESS".equals(ack_code) && !StringUtils.isEmpty((CharSequence)token)) break block7;
            System.err.println("====> \u4eac\u901a\u9753\u8bc1\u83b7\u53d6token.license_login.access_token\uff1afail");
            String string3 = token;
            stopWatch.stop();
            logger.error("====> {} \u4eac\u901a\u9753\u8bc1\u83b7\u53d6token.license_login. \u8017\u65f6 {} \u79d2", new Object[]{lastException == null ? "\u6210\u529f" : "\u5f02\u5e38", lastException, stopWatch.getTotalTimeSeconds()});
            return string3;
        }
        try {
            tokenMap = new HashMap();
            tokenMap.put(token, Instant.now());
            string = token;
        }
        catch (Exception e) {
            String string4;
            try {
                lastException = e;
                string4 = token;
            }
            catch (Throwable throwable) {
                stopWatch.stop();
                logger.error("====> {} \u4eac\u901a\u9753\u8bc1\u83b7\u53d6token.license_login. \u8017\u65f6 {} \u79d2", new Object[]{lastException == null ? "\u6210\u529f" : "\u5f02\u5e38", lastException, stopWatch.getTotalTimeSeconds()});
                throw throwable;
            }
            stopWatch.stop();
            logger.error("====> {} \u4eac\u901a\u9753\u8bc1\u83b7\u53d6token.license_login. \u8017\u65f6 {} \u79d2", new Object[]{lastException == null ? "\u6210\u529f" : "\u5f02\u5e38", lastException, stopWatch.getTotalTimeSeconds()});
            return string4;
        }
        stopWatch.stop();
        logger.error("====> {} \u4eac\u901a\u9753\u8bc1\u83b7\u53d6token.license_login. \u8017\u65f6 {} \u79d2", new Object[]{lastException == null ? "\u6210\u529f" : "\u5f02\u5e38", lastException, stopWatch.getTotalTimeSeconds()});
        return string;
    }

    private String getLicenseToken() {
        Instant now = Instant.now();
        if (tokenMap.isEmpty()) {
            logger.error("1\uff0cgenerateToken.tokenMap.size={}", (Object)tokenMap.size());
            return this.generateToken();
        }
        String latestToken = null;
        Instant latestTime = null;
        for (Map.Entry entry : tokenMap.entrySet()) {
            if (latestTime != null && !((Instant)entry.getValue()).isAfter(latestTime)) continue;
            latestToken = (String)entry.getKey();
            latestTime = (Instant)entry.getValue();
        }
        Duration duration = Duration.between(latestTime, now);
        if (duration.toHours() >= 6L) {
            logger.error("2\uff0cuse token.hour={}", (Object)duration.toHours());
            return this.generateToken();
        }
        logger.error("3\uff0cuse not expired token");
        return latestToken;
    }

    private Result sendSignature(String stamp_xy, String baseeContent, String file_name) {
        try {
            String[] xyArr = stamp_xy.split(",");
            JSONObject json = new JSONObject();
            json.put("appId", (Object)this.appid);
            json.put("file", (Object)new File(file_name, baseeContent, "pdf", file_name + " \u7b7e\u7ae0"));
            JSONObject seal = new JSONObject();
            seal.put("sealInfo", (Object)new SealInfo(this.sealno, "FALSE"));
            JSONObject ruleInfo = new JSONObject();
            ruleInfo.put("version", (Object)"1.0");
            ruleInfo.put("ruleId", (Object)"");
            ruleInfo.put("ruleType", (Object)"RECTANGLE");
            ruleInfo.put("rectangleRule", (Object)new RectangleRule(xyArr[0], xyArr[1], xyArr[2], xyArr[3], xyArr[3]));
            seal.put("ruleInfo", (Object)ruleInfo);
            json.put("seal", (Object)seal);
            String ret = HttpUtil.post((String)(this.api + "/channel/stampFile"), (String)json.toJSONString());
            log.info("====> \u6587\u4e66\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.sendSignature.ret\uff1a" + ret);
            if (StringUtils.isEmpty((CharSequence)ret)) {
                return Result.fail((String)"\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25\uff1a\u8fd4\u56de\u7a7a");
            }
            return (Result)JSON.parseObject((String)ret, Result.class);
        }
        catch (Exception e) {
            log.info("====> \u7b7e\u7ae0\u4e1a\u52a1\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.sendSignature message:" + e.getMessage());
            return Result.fail((String)("\u63a5\u53e3\u8bf7\u6c42\u5f02\u5e38\uff1a" + e.getMessage()));
        }
    }

    private Result verifySignature(String baseeContent, String file_name) {
        try {
            JSONObject json = new JSONObject();
            json.put("appId", (Object)this.appid);
            json.put("file", (Object)new File(file_name, baseeContent, "pdf", file_name + " \u7b7e\u7ae0"));
            String ret = HttpUtil.post((String)(this.api + "/channel/verifyFile"), (String)json.toJSONString());
            log.info("====> \u6587\u4e66\u9a8c\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.verifySignature.ret\uff1a" + ret);
            if (StringUtils.isEmpty((CharSequence)ret)) {
                return Result.fail((String)"\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25\uff1a\u8fd4\u56de\u7a7a");
            }
            return (Result)JSON.parseObject((String)ret, Result.class);
        }
        catch (Exception e) {
            log.info("====> \u6587\u4e66\u9a8c\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.verifySignature message:" + e.getMessage());
            return Result.fail((String)("\u63a5\u53e3\u8bf7\u6c42\u5f02\u5e38\uff1a" + e.getMessage()));
        }
    }
}

