package com.zbkj.common.request.bcx;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;

@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "OrderSaveUrlRequest对象", description = "保存风评订单报告url请求对象")
public class OrderSaveUrlRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "订单编号", required = true)
    @NotEmpty(message = "订单编号不能为空")
    private String orderNo;

    @ApiModelProperty(value = "订单外部url")
//    @NotEmpty(message = "订单外部url不能为空")
    private String url;

    @ApiModelProperty(value = "区域编码", required = true)
    @NotEmpty(message = "区域编码不能为空")
    private String regionCode;
}
