package com.zbkj.common.model.huifu;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <b> 企业钱包账户交易记录 </b>
 * @author ZXF
 * @create 2023/07/26 0026 16:48
 * @version
 * @注意事项 </b>
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("eb_js_pay_trade")
@ApiModel(value="JsPayTrade对象", description="C端交易记录")
public class JsPayTrade implements Serializable {

    @ApiModelProperty(value = "id")
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;
    @ApiModelProperty(value = "用户联合ID")
    private String uniId;
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
    @ApiModelProperty(value = "请求流水号")
    private String reqSeqId;
    @ApiModelProperty(value = "全局流水号")
    private String hfSeqId;
    @ApiModelProperty(value = "入账方商户号")
    private String incomeAccountNo;
    @ApiModelProperty(value = "出账方商户号")
    private String outcomeAccountNo;
    @ApiModelProperty(value = "入账方用户联合ID")
    private String inUniId;
    @ApiModelProperty(value = "商品描述")
    private String goodDesc;
    @ApiModelProperty(value = "交易金额")
    private BigDecimal amount;
    @ApiModelProperty(value = "手续费")
    private BigDecimal commissionAmount;
    @ApiModelProperty(value = "备注")
    private String remark;
    @ApiModelProperty(value = "业务交易流水号")
    private String businessPartnerSeq;
    @ApiModelProperty(value = "原业务交易流水号")
    private String oldBusinessPartnerSeq;
    @ApiModelProperty(value = "业务编码")
    private String businessCode;
    @ApiModelProperty(value = "交易类型")
    private String tradeType;
    @ApiModelProperty(value = "交易状态")
    private String tradeStatus;
    @ApiModelProperty(value = "交易完成时间")
    private String transFinishTime;
    @ApiModelProperty(value = "失败原因")
    private String errorMsg;
    @ApiModelProperty(value = "聚合正扫微信拓展参数集合JSON")
    private String wxData;
    @ApiModelProperty(value = "支付宝扩展参数集合")
    private String alipayData;
    @ApiModelProperty(value = "js支付信息")
    private String payInfo;
    @ApiModelProperty(value = "二维码链接")
    private String qrCode;

}