package com.zbkj.common.enums;

/**
 * description：渠道类型：1业务渠道，2区域渠道
 * author：linchunpeng
 * date：2023/10/25
 */
public enum ChangeTypeEnum {

    BUSINESS("业务渠道", 1),
    REGION("区域渠道", 2);

    private final String name;
    private final Integer value;

    ChangeTypeEnum(String name, Integer value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public Integer getValue() {
        return value;
    }

    public static ChangeTypeEnum getInstance(int value) {
        switch (value) {
            case 1:
                return BUSINESS;
            case 2:
                return REGION;
        }
        return null;
    }
}
