package com.zbkj.common.enums;

/**
 * description：业绩报表 关联类型：1渠道表，2部门表，3部门成员表，4用户表-分销商，5用户表-分销员
 * author：linchunpeng
 * date：2023/8/4
 */
public enum BcxPerformanceReportBelongTypeEnum {

    CHANNEL("渠道表", 1),
    DEPARTMENT("部门表", 2),
    DEPARTMENT_MEMBER("部门成员表", 3),
    USER_FXS("分销商", 4),
    USER_FXY("分销员", 5);

    private final String name;
    private final Integer value;

    BcxPerformanceReportBelongTypeEnum(String name, Integer value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public Integer getValue() {
        return value;
    }
}
