package com.zbkj.common.dto;

import com.zbkj.common.model.huifu.HuifuWalletAccount;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * <b> 钱包账户dto </b>
 * @author ZXF
 * @create 2023/07/31 0031 11:21
 * @version
 * @注意事项 </b>
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="HuifuWalletAccountDto对象", description="钱包账户dto")
public class HuifuWalletAccountDto extends HuifuWalletAccount {

    @ApiModelProperty(value = "验证码")
    private String activeCode;

    @ApiModelProperty(value = "短信类型")
    private String smsType;

    @ApiModelProperty(value = "账户状态")
    private String accountStatus;

    @ApiModelProperty(value = "卡类型：对公，1：对私，2：对私非法人")
    private String cardType;
    @ApiModelProperty(value = "业务类型：D1：下一自然日到银行账户，D0：当日到银行账户；多个逗号隔开")
    private String cashType;
    @ApiModelProperty(value = "卡户名")
    private String cardName;
    @ApiModelProperty(value = "卡号")
    private String cardNo;
    @ApiModelProperty(value = "银行所在省")
    private String provId;
    @ApiModelProperty(value = "银行所在市")
    private String areaId;
    @ApiModelProperty(value = "银行号")
    private String bankCode;
    @ApiModelProperty(value = "支行联行号")
    private String branchCode;
    @ApiModelProperty(value = "支行名称")
    private String branchName;
    @ApiModelProperty(value = "取现卡序列号")
    private String tokenNo;

    @ApiModelProperty(value = "开始日期")
    private String startDate;

    @ApiModelProperty(value = "结束日期")
    private String endDate;

    @ApiModelProperty(value = "金额")
    private BigDecimal amount;

    @ApiModelProperty(value = "充值前端回调页面")
    private String callfrontUrl;

    @ApiModelProperty(value = "订单号")
    private String orderId;
    @ApiModelProperty(value = "到账日期类型D0：当日到账；当日交易资金当天可取现到账；D1：次自然日到账；")
    private String intoAcctDateType;

    @ApiModelProperty(value = "每页条数")
    private Integer pageSize;// 每页条数
    @ApiModelProperty(value = "第几页")
    private Integer pageNumber;// 第几页
}
