package com.bcxin.runtime.apis.responses;

import lombok.Getter;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;

@Getter
public class ChangeLogResponse {
    private final String id;
    private final String name;
    private final String path;
    private final long total;
    private final long current;
    private final String result;
    private final String createdTime;

    public ChangeLogResponse(String id, String name, String path, long total, long current, String result, Timestamp createdTime) {
        this.id = id;
        this.name = name;
        this.path = String.format("%s;%s", path, result);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        this.createdTime = dateFormat.format(createdTime);

        this.total = total;
        this.current = current;
        this.result = result;
    }

    public static ChangeLogResponse create(String id, String name, String path, long total, long current, String result, Timestamp createdTime) {
        ChangeLogResponse logResponse = new ChangeLogResponse(id, name, path, total, current, result, createdTime);

        return logResponse;
    }

    public String getProcess() {
        return String.format("%s/%s", current, total);
    }
}
