package com.bcxin.runtime.apis.dtos;

import cn.hutool.core.date.DateTime;
import cn.myapps.common.util.StringUtil;
import com.alibaba.fastjson.JSON;
import io.swagger.models.auth.In;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.stream.Collectors;

@Getter
public class SyncChangeLogTableDto {
    private final String tableName;
    private final boolean isOnline;
    private final String config;
    private final String target_config;
    private final String url;
    private final String appId;
    private final String name;

    private final String filter;
    private final Timestamp refreshTime;
    private Collection<ChangeLogTableMapDto> tableMaps;

    public String getDisplayName() {
        return String.format("%s(%s)", this.getName(), this.getTableName());
    }

    public SyncChangeLogTableDto(String name, String tableName, String filter, String appId, String config, String target_config,
                                 String url, boolean isOnline) {
        this.name = name;
        this.tableName = tableName;
        this.filter = filter;
        this.isOnline = isOnline;
        this.config = config;
        this.target_config = target_config;
        this.url = url;
        this.appId = appId;
        this.refreshTime = Timestamp.from(Instant.now());
    }

    public String getSql(String regionId, DateTime fromTime,DateTime endTime) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        Calendar calendar = Calendar.getInstance();
        calendar.setTime(endTime);
        Date expectedEndTime = calendar.getTime();
        if (!StringUtil.isBlank(regionId)) {
            if (this.getTableName().contains("sync_employee_view")) {
                return String.format("SELECT * FROM %s where (LASTMODIFIED>='%s' and LASTMODIFIED<='%s') %s and " +
                                " domain_id IN ( SELECT id FROM obpm2.tenant_organizations \n" +
                                "                WHERE supervise_region_code like '%s') order by LASTMODIFIED asc ",
                        this.getTableName(),
                        dateFormat.format(fromTime),
                        dateFormat.format(expectedEndTime),
                        StringUtils.hasLength(this.getFilter()) ? this.getFilter() : "",
                        regionId.concat("%"));
            } else {
                return String.format("SELECT * FROM %s where (LASTMODIFIED>='%s' and LASTMODIFIED<'%s') %s and " +
                                " domainid IN ( SELECT id FROM obpm2.tenant_organizations \n" +
                                "                WHERE supervise_region_code like '%s') order by LASTMODIFIED asc ",
                        this.getTableName(),
                        dateFormat.format(fromTime),
                        dateFormat.format(expectedEndTime),
                        StringUtils.hasLength(this.getFilter()) ? this.getFilter() : "",
                        regionId.concat("%"));
            }
        } else {
            //针对内网环境
            return String.format("SELECT * FROM %s where (LASTMODIFIED>='%s' and LASTMODIFIED<'%s') %s order by LASTMODIFIED asc ",
                    this.getTableName(), dateFormat.format(fromTime), dateFormat.format(expectedEndTime),
                    StringUtils.hasLength(this.getFilter()) ? this.getFilter() : ""
            );
        }
    }

    @Getter(AccessLevel.NONE)
    @Setter(AccessLevel.NONE)
    private String _mapKey;

    public String getMapKey() {
        if (!StringUtils.hasLength(_mapKey) && StringUtils.hasLength(this.getConfig())) {
            _mapKey = (String) JSON.parseObject(this.getConfig()).get("mapKey");
        }

        return _mapKey;
    }

    public void assignTemplates(Collection<ChangeLogTableMapDto> tableMaps) {
        this.tableMaps = tableMaps;
    }

    public static SyncChangeLogTableDto create(String name, String tableName,String filter,  String appId, String config,
                                               String target_config, String url, boolean is_online) {
        return new SyncChangeLogTableDto(name, tableName, filter, appId, config, target_config, url, is_online);
    }

    @Override
    public String toString() {
        return String.format("appId=%s;name=%s;tableName=%s;is_online=%s;", this.getAppId(), this.getName(), this.getTableName(), this.isOnline());
    }

    public Collection<String> getTemplates() {
        if (CollectionUtils.isEmpty(this.getTableMaps())) {
            return Collections.emptyList();
        }

        return this.getTableMaps().stream().map(ii -> ii.getTemplate()).collect(Collectors.toList());
    }
}
