import request from "@/api/request";
// import qs from "qs";

//发起音视频调度及联动值验证
//参数：
// {
//     "roomUsers": [
//       {
//         "employeeId": "string",
//         "organizationId": "string",
//         "tencentUserId": "string",
//         "securityStationId": "string",
//         "superviseDepartId": "string",
//         "sponsor": true
//       }
//     ]
//   }
export function getRooms(data) {
  return request({
    url: "/rooms",
    method: "POST",
    data,
    // headers: { "content-type": "application/x-www-form-urlencoded" },
    // data: qs.stringify(params),
  });
}

export const leave = (roomsId) => {
  return request({
    url: `/rooms/${roomsId}/leave`,
    method: "POST",
  });
};

export function inviteUsers(roomId, roomUsers) {
  console.log("roomUsers", roomUsers);
  return request({
    url: "/rooms/" + roomId + "/users",
    method: "POST",
    data: roomUsers,
  });
}

// 移除人员进房间
export function kickOutUser(roomId, tencentUserId) {
  return request({
    url: "/rooms/" + roomId + "/users/" + tencentUserId,
    method: "DELETE",
  });
}

//房间内动作: 动作类型（action）：stopWord#全员静音  openWord#全员解除静音 allowed#允许发言请求  deny#拒绝发言请求  camOn #全员打开摄像头  camOff #全员关闭摄像头
// {
//   "action": "stopWord",
//   "tencentUserIds": [
//     "string"
//   ]
// }
export function roomActions(roomId, data) {
  return request({
    url: "/rooms/" + roomId + "/action",
    method: "POST",
    data,
  });
}
