/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.autodownloadupload.common.utils;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DatabaseUtil {
    private static final Logger log = LoggerFactory.getLogger(DatabaseUtil.class);

    public static Connection getConnection(String url, String username, String password) throws Exception {
        return DriverManager.getConnection(url, username, password);
    }

    public static void executeSql(Connection connection, String sql) throws Exception {
        Statement statement = null;
        try {
            connection.setAutoCommit(false);
            statement = connection.createStatement();
            statement.execute(sql);
            connection.commit();
        }
        catch (Exception e) {
            try {
                connection.rollback();
            }
            catch (SQLException excep) {
                excep.printStackTrace();
            }
            log.error("\u6279\u91cf\u6267\u884csql\u811a\u672c\u51fa\u9519\uff0c{}", (Object)e.getMessage(), (Object)e);
            throw e;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static void batchExecuteSql(Connection connection, List<String> sqlList, int batchSize) throws Exception {
        Statement statement = null;
        try {
            connection.setAutoCommit(false);
            statement = connection.createStatement();
            int count = 0;
            for (String sql : sqlList) {
                if (StringUtils.isBlank((CharSequence)sql)) continue;
                statement.addBatch(sql);
                if (++count % batchSize != 0) continue;
                int[] execCount = statement.executeBatch();
                log.info("JDBC\u6279\u91cf\u6267\u884c\u6761\u6570\uff1a{}", (Object)execCount.length);
                statement.clearBatch();
            }
            if (count % batchSize != 0) {
                int[] execCount = statement.executeBatch();
                log.info("JDBC\u6279\u91cf\u6267\u884c\u6761\u6570\uff1a{}", (Object)execCount.length);
                statement.clearBatch();
            }
            connection.commit();
        }
        catch (Exception e) {
            try {
                connection.rollback();
            }
            catch (SQLException excep) {
                excep.printStackTrace();
            }
            log.error("\u6279\u91cf\u6267\u884csql\u811a\u672c\u51fa\u9519\uff0c{}", (Object)e.getMessage(), (Object)e);
            throw e;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static String execCommand(boolean isWindows, String ip, String port, String username, String password, String filePath) throws Exception {
        StringBuilder result = new StringBuilder("");
        Process process = null;
        InputStream ins = null;
        String command = String.format("mysql -h%s -P%s -u%s -p%s -D baiduutil -e \"source %s\" ", ip, port, username, password, filePath);
        log.info("\u901a\u8fc7\u547d\u4ee4\u884c\u6267\u884csql\u811a\u672c\uff0c\u547d\u4ee4\uff1a{}", (Object)command);
        try {
            process = isWindows ? Runtime.getRuntime().exec(new String[]{"cmd", "/c", command}) : Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", command});
            process.waitFor();
            ins = process.getErrorStream();
            byte[] b = new byte[100];
            int num = 0;
            try {
                while ((num = ins.read(b)) != -1) {
                    result.append(new String(b, "gb2312"));
                }
            }
            catch (IOException e) {
                log.error("\u83b7\u53d6\u547d\u4ee4\u884c\u6267\u884c\u7ed3\u679c\u5931\u8d25\uff0cfilePath\uff1a{}\uff0c{}", new Object[]{filePath, e.getMessage(), e});
                throw e;
            }
        }
        catch (Exception e) {
            log.error("\u547d\u4ee4\u884c\u6267\u884c\u811a\u672c\u5931\u8d25\uff0cfilePath\uff1a{}\uff0c{}", new Object[]{filePath, e.getMessage(), e});
            throw e;
        }
        finally {
            try {
                assert (ins != null);
                ins.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            process.destroy();
        }
        return result.toString();
    }

    public static void main(String[] args) throws Exception {
        String result = DatabaseUtil.execCommand((boolean)true, (String)"127.0.0.1", (String)"3306", (String)"root", (String)"123456", (String)"D:\\data\\baidu\\push\\202305260944585482\\sql\\__KDXZvc8mnEmDqMARhK7GTLK_LEGALCHANGE_CHANGE___KDXZvc8mnEmDqMARhK7G.sql");
        log.info(result);
        if (result.contains("ERROR")) {
            result = result.substring(result.indexOf("ERROR"));
            log.info(result);
        }
    }
}

