package com.bcxin.tenant.bcx.infrastructures.models;

import lombok.Data;

import java.io.Serializable;

@Data
public class AgentHeaderOptionValue implements Serializable {
    private String agent;
    private String device;
    private String empId;
    private String comId;
    private Object tag;

    private String actionCode;

    public static AgentHeaderOptionValue create(String agent, String device,
                                                String empId, String comId,
                                                String actionCode) {
        AgentHeaderOptionValue optionValue = new AgentHeaderOptionValue();
        optionValue.setAgent(agent);
        optionValue.setDevice(device);
        optionValue.setComId(comId);
        optionValue.setEmpId(empId);
        optionValue.setActionCode(actionCode);

        return optionValue;
    }

    public void assignTag(String tag) {
        this.setTag(tag);
    }

    public String toString() {
        return String.format("a=%s|d=%s|e=%s|c=%s|t=%s|i=%s", agent, device, empId, comId, tag, actionCode);
    }
}
