package com.bcxin.tenant.bcx.infrastructures.components;

import com.bcxin.tenant.bcx.infrastructures.components.models.ExcelModelAbstract;

import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public interface ExcelProvider {
    public final String ATTRIBUTE_HEADER_ROW_COUNT="ATTRIBUTE_HEADER_ROW_COUNT";
    public final String ATTRIBUTE_SHEET_NAME="ATTRIBUTE_SHEET_NAME";

    Collection<Map<Integer,String>> read(InputStream reader, Map<String,Object> attributes);

    <T extends ExcelModelAbstract> Collection<T> read(InputStream reader, Class<T> tClass);

    <T extends ExcelModelAbstract> Collection<T> read(InputStream reader, Class<T> tClass, String sheetName);

    <T extends ExcelModelAbstract> void read(InputStream reader, Class<T> tClass, String sheetName, Consumer<List<T>> consumer);

    <T extends ExcelModelAbstract> void read(InputStream reader, Class<T> tClass,
                                             int pageSize,
                                             Consumer<List<T>> consumer);
}
