package com.bcxin.tenant.bcx.jdks.responses.pages;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.bcxin.tenant.bcx.infrastructures.ResponseAbstract;
import com.bcxin.tenant.bcx.infrastructures.enums.PageBusinessType;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Map;

@Schema(name = "PageDataResponse",title = "动态页面数据")
@Getter
public class PageDataResponse extends ResponseAbstract {
    @Schema(name = "id", title = "id")
    private final String id;
    @ExcelIgnore
    @Schema(name = "pageId", title = "页面Id")
    private final String pageId;
    @ExcelIgnore
    @Schema(name = "businessType", title = "业务类型")
    private final PageBusinessType businessType;

    @ExcelIgnore
    private final Map<String, Object> items;
    @ColumnWidth(50)
    @ExcelProperty("创建时间")
    private final String createdTime;

    @ColumnWidth(50)
    @ExcelProperty("最后修改时间")
    private final String lastUpdatedTime;

    public String getBusinessTypeLabel(){
        return businessType.getName();
    }

    public PageDataResponse(String id, String pageId, PageBusinessType businessType,
                            Map<String, Object> items,
                            Timestamp createdTime,
                            Timestamp lastUpdatedTime) {
        this.id = id;
        this.pageId = pageId;
        this.businessType = businessType;
        this.items = items;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (createdTime == null) {
            this.createdTime = "-";
        } else {
            this.createdTime = dateFormat.format(createdTime);
        }

        if (lastUpdatedTime == null) {
            this.lastUpdatedTime = "-";
        } else {
            this.lastUpdatedTime = dateFormat.format(lastUpdatedTime);
        }
    }

    public static PageDataResponse create(String id, String pageId, PageBusinessType businessType,
                                          Map<String, Object> items,
                                          Timestamp createdTime,
                                          Timestamp lastUpdatedTime) {
        return new PageDataResponse(id, pageId, businessType, items,createdTime,lastUpdatedTime);
    }
}
