package com.bcxin.tenant.bcx.infrastructures.utils;

import com.bcxin.tenant.bcx.infrastructures.exceptions.BadTenantException;
import com.bcxin.tenant.bcx.infrastructures.exceptions.IgnoreTenantException;
import com.bcxin.tenant.bcx.infrastructures.exceptions.RetryableTenantException;
import com.bcxin.tenant.bcx.infrastructures.exceptions.TenantExceptionAbstract;

import java.io.PrintWriter;
import java.io.StringWriter;

public  class ExceptionUtil  {
    /**
     * 将CheckedException转换为UncheckedException.
     */
    public static RuntimeException unchecked(Exception e) {
        /**
         * Java16的新特性；避免三次转换;
         */
        if (e instanceof RuntimeException ex) {
            return ex;
        } else {
            return new RuntimeException(e);
        }
    }

    /**
     * 将ErrorStack转化为String.
     */
    public static String getStackTraceAsString(Throwable e) {
        if (e == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    /**
     * 判断异常是否由某些底层的异常引起.
     */
    public static boolean isCausedBy(Exception ex, Class<? extends Exception>... causeExceptionClasses) {
        Throwable cause = ex.getCause();
        while (cause != null) {
            for (Class<? extends Exception> causeClass : causeExceptionClasses) {
                if (causeClass.isInstance(cause)) {
                    return true;
                }
            }
            cause = cause.getCause();
        }
        return false;
    }

    public static <T extends Exception> T cast(Exception ex, Class<T> targetClass) {
        assert ex != null;

        if (!targetClass.isAssignableFrom(ex.getClass())) {
            return null;
        }

        return (T) ex;
    }

    public static <T extends Exception> boolean is(Throwable ex, Class<T> targetClass) {
        assert ex != null;

        return targetClass.isAssignableFrom(ex.getClass());
    }

    public static String getStackMessage(Throwable throwable) {
        if (throwable == null) {
            return "";
        }

        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw)) {
            throwable.printStackTrace(pw);
        }

        return sw.toString();
    }

    public static TenantExceptionAbstract returnExpectedException(Exception ex,String defaultMessage) {
        Throwable checkException = ex;
        int tryCount = 0;
        if (ex.getCause() != null) {
            checkException = ex.getCause();
            while (checkException.getCause() != null && !(checkException instanceof TenantExceptionAbstract) && tryCount < 10) {
                checkException = checkException.getCause();
                tryCount++;
            }
        }
        if (checkException instanceof TenantExceptionAbstract) {
            if (!(checkException instanceof IgnoreTenantException || checkException instanceof RetryableTenantException)) {
                return (TenantExceptionAbstract) checkException;
            } else {
                throw new BadTenantException(checkException.getMessage(), ex);
            }
        }

        return new BadTenantException(defaultMessage, ex);
    }
}
