/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.enums.RollCallStatus;
import com.bcxin.tenant.open.infrastructures.enums.RollCallType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Collection;

@Schema(name="RollCallEmployeeSearchResponse", title="\u6211\u7684\u88ab\u70b9\u540d\u8bb0\u5f55")
public class RollCallEmployeeSearchResponse
extends ResponseAbstract {
    @Schema(name="rollCallId", title="\u70b9\u540dId")
    private final String rollCallId;
    @Schema(name="callStatusLabel", title="\u70b9\u540d\u7c7b\u578b/\u72b6\u6001\u7684\u4e2d\u6587\u63cf\u8ff0")
    private final String callStatusLabel;
    @Schema(name="callTypeLabel", title="\u70b9\u540d\u7c7b\u578b/\u72b6\u6001\u7684\u4e2d\u6587\u63cf\u8ff0")
    private final String callTypeLabel;
    @Schema(name="actionOrganizationName", title="\u53d1\u8d77\u70b9\u540d\u7684\u5355\u4f4d(\u6d3e\u51fa\u6240\u6216\u8005\u5355\u4f4d)")
    private final String actionOrganizationName;
    @Schema(name="securityStationId", title="\u6240\u5728\u9a7b\u52e4\u70b9Id")
    private final String securityStationId;
    @Schema(name="securityStationName", title="\u6240\u5728\u9a7b\u52e4\u70b9")
    private final String securityStationName;
    @Schema(name="calledEmployeeId", title="\u88ab\u70b9\u540d\u7684\u4eba\u5458\u7684\u804c\u5458Id")
    private final String calledEmployeeId;
    @Schema(name="calledEmployeeName", title="\u88ab\u70b9\u540d\u7684\u4eba\u5458\u7684\u59d3\u540d")
    private final String calledEmployeeName;
    @Schema(name="calledTenantUserId", title="\u88ab\u70b9\u540d\u7684\u4eba\u7684Id")
    private final String calledTenantUserId;
    @Schema(name="stationResponsible", title="\u662f\u5426\u4e3a\u9a7b\u52e4\u70b9\u8d1f\u8d23\u4eba")
    private final boolean stationResponsible;
    @Schema(name="tencentUserId", title="\u97f3\u89c6\u9891\u7684\u817e\u8bafUserId")
    private final String calledTencentUserId;
    @Schema(name="calledOrganizationId", title="\u88ab\u70b9\u540d\u7684\u4eba\u6240\u5728\u7684\u4f01\u4e1aId")
    private final String calledOrganizationId;
    @Schema(name="calledOrganizationName", title="\u88ab\u70b9\u540d\u7684\u4eba\u6240\u5728\u7684\u4f01\u4e1a\u540d\u79f0")
    private final String calledOrganizationName;
    @Schema(name="createdTime", title="\u70b9\u540d\u65f6\u95f4")
    private final String createdTime;
    @Schema(name="createdDate", title="\u70b9\u540d\u65e5\u671f")
    private final String createdDate;
    @Schema(name="superviseDepartId", title="\u8f96\u533aId")
    private final String superviseDepartId;

    public RollCallEmployeeSearchResponse(Long rollCallId, Timestamp createdTime, int callType, int callStatus, String actionOrganizationName, String securityStationId, String securityStationName, String superviseDepartId, String calledEmployeeId, String calledEmployeeName, String calledTenantUserId, String calledTencentUserId, String calledOrganizationId, String calledOrganizationName, boolean stationResponsible) {
        this.rollCallId = String.valueOf(rollCallId);
        Collection selectedRollCallStatuses = RollCallStatus.getSelectedRollCallStatuses((int)callStatus);
        String statusLabel = "\u70b9\u540d\u4e2d";
        Collection callTypes = RollCallType.getSelectedRollCallTypes((int)callType);
        this.callTypeLabel = callTypes.contains(RollCallType.Dispatch) ? "\u7763\u5bfc\u70b9\u540d" : "\u70b9\u540d\u8f6e\u8be2";
        if (selectedRollCallStatuses.contains(RollCallStatus.DispatchInit)) {
            statusLabel = "\u7763\u5bfc\u70b9\u540d\u4e2d";
        }
        if (selectedRollCallStatuses.contains(RollCallStatus.RollCallSuccess)) {
            statusLabel = "\u70b9\u540d\u6210\u529f";
        }
        if (selectedRollCallStatuses.contains(RollCallStatus.RollCallFailed)) {
            statusLabel = "\u70b9\u540d\u5931\u8d25";
        }
        if (selectedRollCallStatuses.contains(RollCallStatus.DispatchSuccess)) {
            statusLabel = "\u7763\u5bfc\u70b9\u540d\u6210\u529f";
        }
        if (selectedRollCallStatuses.contains(RollCallStatus.DispatchFailed)) {
            statusLabel = "\u7763\u5bfc\u70b9\u540d\u5931\u8d25";
        }
        this.callStatusLabel = statusLabel.toString();
        this.actionOrganizationName = actionOrganizationName;
        this.securityStationId = securityStationId;
        this.securityStationName = securityStationName;
        this.createdTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(createdTime);
        this.createdDate = new SimpleDateFormat("yyyy-MM-dd").format(createdTime);
        this.superviseDepartId = superviseDepartId;
        this.calledEmployeeId = calledEmployeeId;
        this.calledEmployeeName = calledEmployeeName;
        this.calledTenantUserId = calledTenantUserId;
        this.calledTencentUserId = calledTencentUserId;
        this.calledOrganizationId = calledOrganizationId;
        this.calledOrganizationName = calledOrganizationName;
        this.stationResponsible = stationResponsible;
    }

    public static RollCallEmployeeSearchResponse create(Long rollCallId, Timestamp createdTime, int callType, int callStatus, String actionOrganizationName, String securityStationId, String securityStationName, String superviseDepartId, String calledEmployeeId, String calledEmployeeName, String calledTenantUserId, String calledTencentUserId, String calledOrganizationId, String calledOrganizationName, boolean stationResponsible) {
        return new RollCallEmployeeSearchResponse(rollCallId, createdTime, callType, callStatus, actionOrganizationName, securityStationId, securityStationName, superviseDepartId, calledEmployeeId, calledEmployeeName, calledTenantUserId, calledTencentUserId, calledOrganizationId, calledOrganizationName, stationResponsible);
    }

    public String getRollCallId() {
        return this.rollCallId;
    }

    public String getCallStatusLabel() {
        return this.callStatusLabel;
    }

    public String getCallTypeLabel() {
        return this.callTypeLabel;
    }

    public String getActionOrganizationName() {
        return this.actionOrganizationName;
    }

    public String getSecurityStationId() {
        return this.securityStationId;
    }

    public String getSecurityStationName() {
        return this.securityStationName;
    }

    public String getCalledEmployeeId() {
        return this.calledEmployeeId;
    }

    public String getCalledEmployeeName() {
        return this.calledEmployeeName;
    }

    public String getCalledTenantUserId() {
        return this.calledTenantUserId;
    }

    public boolean isStationResponsible() {
        return this.stationResponsible;
    }

    public String getCalledTencentUserId() {
        return this.calledTencentUserId;
    }

    public String getCalledOrganizationId() {
        return this.calledOrganizationId;
    }

    public String getCalledOrganizationName() {
        return this.calledOrganizationName;
    }

    public String getCreatedTime() {
        return this.createdTime;
    }

    public String getCreatedDate() {
        return this.createdDate;
    }

    public String getSuperviseDepartId() {
        return this.superviseDepartId;
    }
}

