package com.bcxin.tenant.open.domains.services.commands;

import com.bcxin.tenant.open.infrastructures.commands.CommandAbstract;
import com.bcxin.tenant.open.infrastructures.enums.RollCallStatus;
import com.bcxin.tenant.open.infrastructures.enums.RollCallType;
import lombok.Getter;

import java.util.Collection;

/**
 * 在APP回复的时候调用此功能
 */
@Getter
public class ReplyRollCallEmployeeStatusCommand extends CommandAbstract {
    private final Long id;
    private final Collection<String> employeeIds;

    private final RollCallType callType;

    private final RollCallStatus callStatus;

    public ReplyRollCallEmployeeStatusCommand(Long id, Collection<String> employeeIds, RollCallType callType,RollCallStatus callStatus) {
        this.id = id;
        this.employeeIds = employeeIds;
        this.callStatus = callStatus;
        this.callType = callType;
    }

    public static ReplyRollCallEmployeeStatusCommand create(Long id, Collection<String> employeeIds, RollCallType callType,RollCallStatus callStatus) {
        return new ReplyRollCallEmployeeStatusCommand(id, employeeIds, callType,callStatus);
    }
}
