package com.bcxin.tenant.open.domains.services.commands;

import com.bcxin.tenant.open.infrastructures.commands.CommandAbstract;
import com.bcxin.tenant.open.infrastructures.enums.ContentFollowType;
import com.bcxin.tenant.open.infrastructures.exceptions.BadTenantException;
import lombok.Getter;
import org.springframework.util.StringUtils;

@Getter
public class CreateTenantContentFollowCommand extends CommandAbstract {
    private final ContentFollowType followType;
    private final String contentFollowId;
    private final String deviceNo;
    private final String followUserId;

    public CreateTenantContentFollowCommand(
            ContentFollowType followType,
            String contentFollowId,
            String deviceNo, String followUserId) {
        this.followType = followType;
        this.contentFollowId = contentFollowId;
        this.deviceNo = deviceNo;
        this.followUserId = followUserId;
    }

    @Override
    public void validate() {
        super.validate();

        if (this.getFollowType() == null) {
            throw new BadTenantException("关注内容的类型不能为空");
        }

        if (!StringUtils.hasLength(this.getContentFollowId())) {
            throw new BadTenantException("关注内容的Id(contentFollowId)信息不能为空!");
        }

        if (!StringUtils.hasLength(this.getDeviceNo())) {
            throw new BadTenantException("关注人身份(deviceNo)信息不能为空!");
        }

        if (!StringUtils.hasLength(this.getFollowUserId())) {
            throw new BadTenantException("关注人Id(followerId)信息不能为空!");
        }
    }

    public static CreateTenantContentFollowCommand create(
            ContentFollowType followType,
            String contentFollowId,
            String deviceNo,
            String followUserId

    ) {
        CreateTenantContentFollowCommand command = new CreateTenantContentFollowCommand(
                followType, contentFollowId, deviceNo, followUserId
        );

        return command;
    }
}