package com.bcxin.tenant.open.domains.repositories;

import com.bcxin.tenant.open.domains.entities.RoomEntity;
import com.bcxin.tenant.open.domains.entities.RoomUserEntity;
import com.bcxin.tenant.open.infrastructures.repositories.RepositoryBase;

import java.util.Collection;

public interface RoomRepository extends RepositoryBase<RoomEntity> {
    void insert(RoomEntity room);

    Collection<Long> getReadyForCalculatedRoomIds(int pageSize);

    void addRoomUsers(Collection<RoomUserEntity> users);

    Collection<RoomUserEntity> getRoomUsersByRoomIds(Collection<String> roomIds);

    void removeUsers(long roomId, Collection<String> userIds);
}
