package com.bcxin.tenant.open.domains.entities;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.RoomUserStatus;
import lombok.Data;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.Timestamp;
import java.time.Instant;

@TableName(value = "vga_room_users",autoResultMap = true)
@Data
public class RoomUserEntity extends EntityAbstract implements Aggregate {
    @TableId(value = "id")
    private Long id;

    @TableField(value = "employee_id")
    private String employeeId;
    @TableField(value = "tenant_user_id")
    private String tenantUserId;
    @TableField(value = "cid")
    private String cid;
    @TableField(value = "employee_name")
    private String employeeName;
    @TableField(value = "organization_id")
    private String organizationId;
    @TableField(value = "organization_name")
    private String organizationName;
    @TableField(value = "tencent_user_id")
    private String tencentUserId;
    @TableField(value = "security_station_id")
    private String securityStationId;
    @TableField(value = "security_station_name")
    private String securityStationName;

    @TableField(value = "project_id")
    private String projectId;
    @TableField(value = "project_name")
    private String projectName;

    @TableField(value = "supervise_depart_id")
    private String superviseDepartId;
    @TableField(value = "is_sponsor")
    private boolean isSponsor;
    @TableField(value = "room_id")
    private Long roomId;
    @TableField(value = "created_time")
    private Timestamp createdTime;
    @TableField(value = "is_supervise_role")
    private boolean isSuperviseRole;

    @TableField(value = "leave_time")
    private Timestamp leaveTime;

    @TableField(value = "status", jdbcType = JdbcType.TINYINT, typeHandler = EnumOrdinalTypeHandler.class)
    private RoomUserStatus status;

    public RoomUserEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
        this.setStatus(RoomUserStatus.NONE);
    }

    public static RoomUserEntity create(
            Long roomId,
            Long id,
            String employeeId,
            String tenantUserId,
            String cid,
            String employeeName,
            String organizationId,
            String organizationName,
            String tencentUserId,
            String securityStationId,
            String securityStationName,
            String superviseDepartId,
            boolean isSponsor,
            boolean isSuperviseDepartRole) {
        RoomUserEntity roomUser = new RoomUserEntity();
        roomUser.setId(id);
        roomUser.setRoomId(roomId);
        roomUser.setEmployeeId(employeeId);
        roomUser.setTencentUserId(tencentUserId);
        roomUser.setSponsor(isSponsor);
        roomUser.setOrganizationId(organizationId);
        roomUser.setSuperviseDepartId(superviseDepartId);
        roomUser.setSecurityStationId(securityStationId);
        roomUser.setEmployeeName(employeeName);
        roomUser.setOrganizationName(organizationName);
        roomUser.setSecurityStationName(securityStationName);
        roomUser.setTenantUserId(tenantUserId);
        roomUser.setCid(cid);
        roomUser.setSuperviseRole(isSuperviseDepartRole);

        return roomUser;
    }
}
