package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.domains.pojo.RollCallRulePoJo;
import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import lombok.Data;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collection;

/**
 * 点名信息
 */
@TableName(value = "vga_roll_calls",autoResultMap = true)
@Data
public class RollCallEntity extends EntityAbstract implements Aggregate {
    @TableId("id")
    private Long id;

    /**
     * 点名规则
     * {"planId":xxx,"timeValue":"10:00:01"}
     */
    @TableField("roll_call_rule_json")
    private String rollCallRuleJson;

    /**
     * 监管归属信息
     * ["","",""]
     */
    @TableField("supervise_depart_json")
    private String superviseDepartJson;

    /**
     * 驻勤点信息
     * ["","",""]
     */
    @TableField("security_station_json")
    private String securityStationJson;

    /**
     * 驻勤点类型
     * ["01","02"]
     */
    @TableField("station_type_json")
    private String stationTypeJson;

    /**
     * 发起.点名轮换的组织Id
     */
    @TableField("action_organization_id")
    private String actionOrganizationId;

    /**
     * 发起.点名轮换的组织名称
     */
    @TableField("action_organization_name")
    private String actionOrganizationName;

    /**
     * 发起.点名轮换的人员Id
     */
    @TableField("action_employee_id")
    private String actionEmployeeId;

    /**
     * 发起.点名轮换的人员名字
     */
    @TableField("action_employee_name")
    private String actionEmployeeName;

    /**
     * 发起.点名轮换的时间
     */
    @TableField("created_time")
    private Timestamp createdTime;

    /**
     * 匹配的人员数量
     */
    @TableField("count_of_roll_call_person")
    private int countOfRollCallPerson;

    public RollCallEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public static RollCallEntity create(
            JsonProvider jsonProvider,
            String actionOrganizationId,
            String actionOrganizationName,
            String actionEmployeeId,
            String actionEmployeeName,
            int countOfRollCallPerson,
            Long id,
            RollCallRulePoJo rulePoJo,
            Collection<String> superviseDepartIds,
            Collection<String> securityStationIds,
            Collection<String> stationTypes
    ) {
        RollCallEntity rollCall = new RollCallEntity();
        rollCall.setId(id);
        rollCall.setRollCallRuleJson(jsonProvider.getJson(rulePoJo));
        rollCall.setActionEmployeeId(actionEmployeeId);
        rollCall.setActionEmployeeName(actionEmployeeName);
        rollCall.setActionOrganizationId(actionOrganizationId);
        rollCall.setActionOrganizationName(actionOrganizationName);
        rollCall.setCountOfRollCallPerson(countOfRollCallPerson);

        rollCall.setSecurityStationJson(jsonProvider.getJson(securityStationIds));
        rollCall.setStationTypeJson(jsonProvider.getJson(stationTypes));
        rollCall.setSuperviseDepartJson(jsonProvider.getJson(superviseDepartIds));

        return rollCall;
    }
}
