package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import lombok.Data;

import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;

/**
 * 项目路线图
 */
@TableName(value = "rd_project_roadmaps",autoResultMap = true)
@Data
public class RdProjectRoadmapEntity extends EntityAbstract implements Aggregate {
    @TableId(value = "id")
    private Long id;

    @TableField(value = "name")
    private String name;

    @TableField(value = "roadmap_image_json")
    private String roadmapImageJson;

    @TableField(value = "project_id")
    private String projectId;

    @TableField(value = "roadmap_json")
    private String roadmapJson;

    @TableField(value = "organization_id")
    private String organizationId;

    @TableField(value = "organization_name")
    private String organizationName;

    @TableField(value = "last_updater_id")
    private String lastUpdaterId;

    @TableField(value = "last_updated_time")
    private Timestamp lastUpdatedTime;

    @TableField(value = "creator_id")
    private String creatorId;

    @TableField(value = "created_time")
    private Timestamp createdTime;

    @TableField(value = "deleted")
    private boolean deleted;

    @TableField(value = "delete_id")
    private String deleteId;

    public RdProjectRoadmapEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
        this.setDeleted(false);
        this.setDeleted(false);
        this.setDeleteId(null);

        this.setLastUpdaterId(null);
        this.setLastUpdatedTime(null);
    }

    public void change(String name,
                       String roadmapImageJson,
                       String roadmapJson,
                       String operatorId) {
        this.setName(name);
        this.setRoadmapImageJson(roadmapImageJson);
        this.setRoadmapJson(roadmapJson);

        if (operatorId != null) {
            this.setLastUpdaterId(operatorId);
            this.setLastUpdatedTime(Timestamp.from(Instant.now()));
        }
    }

    public void delete(String operatorId) {
        this.setDeleted(true);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
        this.setDeleteId(operatorId);
    }

    public static RdProjectRoadmapEntity create(String name,
                                                String roadmapImageJson,
                                                String roadmapJson,
                                                String projectId,
                                                String organizationId,
                                                String organizationName,
                                                String operatorId) {
        RdProjectRoadmapEntity projectRoadmap = new RdProjectRoadmapEntity();
        projectRoadmap.change(name,roadmapImageJson,roadmapJson,null);
        projectRoadmap.setProjectId(projectId);
        projectRoadmap.setOrganizationId(organizationId);
        projectRoadmap.setOrganizationName(organizationName);
        projectRoadmap.setCreatorId(operatorId);

        return projectRoadmap;
    }
}
