package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.domains.entities.valueTypes.GeoPointValueType;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import lombok.Data;

/**
 * 考试点信息
 */
@TableName(value = "rd_exam_site_summary",autoResultMap = true)
@Data
public class RdExamSiteEntity extends RdSuperviseEntityAbstract implements Aggregate {

    @TableId("pk_id")
    private Long pkId;

    @TableField(value = "id")
    private String id;

    /**
     * 考试点名称
     */
    @TableField(value = "name")
    private String name;

    /**
     * 企业Id
     */
    @TableField(value = "organization_id")
    private String organizationId;

    /**
     * 所属企业
     */
    @TableField(value = "company_name")
    private String companyName;

    /**
     * 考试点地址
     */
    @TableField(value = "address")
    private String address;

    /**
     * 考场数量
     */
    @TableField(value = "count_of_room")
    private int countOfRoom;

    /**
     * 容纳的人员数量
     */
    @TableField(value = "capacity_of_person")
    private int capacityOfPerson;

    /**
     * 经纬度
     */
    @TableField(value = "lon_lat")
    private String lonLat;

    /**
     * 考试点状态
     * true: 启用
     * false: 禁用
     */
    @TableField(value = "status")
    private boolean status;

    /**
     * 所属区域信息
     */
    @TableField(value = "region_name")
    private String regionName;
}
