package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.domains.entities.valueTypes.GeoPointValueType;
import com.bcxin.tenant.open.domains.typeHandlers.GeoPointTypeHandler;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import lombok.Data;

import java.sql.Timestamp;
import java.time.Instant;

/**
 * 设备的经纬度信息
 */
@TableName(value = "rd_device_location_histories",autoResultMap = true)
@Data
public class RdDeviceLocationHistoryEntity  extends EntityAbstract implements Aggregate {
    @TableId("pk_id")
    private Long pkId;

    @TableField(value = "device_id")
    private String deviceId;

    @TableField(value = "dispatch_no")
    private String dispatchNo;

    @TableField(value = "lon_lat", typeHandler = GeoPointTypeHandler.class)
    private GeoPointValueType lonLat;

    @TableField(value = "created_time")
    private Timestamp createdTime;

    public RdDeviceLocationHistoryEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public static RdDeviceLocationHistoryEntity create(String deviceId,String dispatchNo,GeoPointValueType lonLat){
        RdDeviceLocationHistoryEntity entity = new RdDeviceLocationHistoryEntity();
        entity.setDeviceId(deviceId);
        entity.setDispatchNo(dispatchNo);
        entity.setLonLat(lonLat);

        return entity;
    }
}
