package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import lombok.Data;

import java.sql.Timestamp;
import java.time.Instant;

@TableName(value = "tlk_org_purse",autoResultMap = true)
@Data
public class OrgPurseEntity extends EntityAbstract implements Aggregate {

    @TableField(value = "id")
    private String id;

    @TableField(value = "ITEM_ORGANIZATION_ID")
    private String organizationId;

    @TableField(value = "ITEM_ORGANIZATION_NAME")
    private String organizationName;

    @TableField(value = "ITEM_POINTS")
    private Long points;

    @TableField(value = "ITEM_CREATED_TIME")
    private Timestamp createdTime;

    @TableField(value = "LASTMODIFIED")
    private Timestamp lastmodified;

    @TableField(value = "CREATED")
    private Timestamp created;

    @TableField(value = "FORMID")
    private String formId;

    @TableField(value = "STATELABELINFO")
    private String stateLabelInfo;

    public boolean IsDispatchable() {
        if (this.getPoints() == null) {
            return false;
        }

        return this.getPoints() > 0;
    }

    public OrgPurseEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
        this.setCreated(this.getCreatedTime());
        this.setLastmodified(this.getCreatedTime());
        this.setFormId("__2j5BUeDTuCNmAILwwyt");
        this.setId(String.format("%s--%s", StringUtil.generateShortUuid(), this.getFormId()));
    }

    public void addPoints(long sum,String tranIds) {
        this.setPoints(this.getPoints() + sum);
        this.setLastmodified(Timestamp.from(Instant.now()));
        this.setStateLabelInfo(String.format("TranIds=%s", tranIds));
    }

    public static OrgPurseEntity create(String organizationId,String organizationName, int points) {
        OrgPurseEntity orgPurse = new OrgPurseEntity();
        orgPurse.setPoints((long) points);
        orgPurse.setOrganizationId(organizationId);
        orgPurse.setOrganizationName(organizationName);

        return orgPurse;
    }
}