package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.BillType;
import lombok.Data;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;

@TableName(value = "bill_daily", autoResultMap = true)
@Data
public class DailyBillEntity extends EntityAbstract implements Aggregate {

    @TableField(value = "id")
    private String id;
    @TableField(value = "type", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private BillType type;
    @TableField(value = "organization_id")
    private String orgId;
    @TableField(value = "created_time")
    private Timestamp createdTime;
    @TableField(value = "date")
    private Date date;
    @TableField(value = "bill_month_id")
    private String monthlyBillId;

    @TableField(value = "ope_count")
    private Integer opeCount;
    @TableField(value = "head_count")
    private Integer headCount;

    public DailyBillEntity(){
        this.createdTime = Timestamp.from(Instant.now());
    }
    public static DailyBillEntity create(String id,
                                         BillType type,
                                         String orgId,
                                         Date date,
                                         String monthlyBillId,
                                         Integer opeCount,
                                         Integer headCount) {
        DailyBillEntity dailyBillEntity = new DailyBillEntity();
        dailyBillEntity.setId(id);
        dailyBillEntity.setType(type);
        dailyBillEntity.setOrgId(orgId);
        dailyBillEntity.setDate(date);
        dailyBillEntity.setMonthlyBillId(monthlyBillId);
        dailyBillEntity.setOpeCount(opeCount);
        dailyBillEntity.setHeadCount(headCount);
        return dailyBillEntity;
    }
}
