package com.bcxin.tenant.open.domains.dtos;

import com.bcxin.tenant.open.infrastructures.enums.DispatchAccountType;
import lombok.Data;
import lombok.Getter;

@Getter
public class SosSettingDTO {
    private final String deviceNo;

    private final DispatchAccountType deviceType;

    private final Boolean sosEnabled;

    private final String sosKey;

    private final String operatorId;

    private final String operatorName;


    public SosSettingDTO(String deviceNo, DispatchAccountType deviceType, Boolean sosEnabled, String sosKey, String creatorId, String creatorName) {
        this.deviceNo = deviceNo;
        this.deviceType = deviceType;
        this.sosEnabled = sosEnabled;
        this.sosKey = sosKey;
        this.operatorId = creatorId;
        this.operatorName = creatorName;
    }

    public static SosSettingDTO create(String deviceNo, DispatchAccountType deviceType, Boolean sosEnabled, String sosKey, String creatorId, String creatorName){
        return new SosSettingDTO(deviceNo,deviceType,sosEnabled,sosKey,creatorId,creatorName);
    }
}