package com.bcxin.tenant.open.domains.criterias;

import com.bcxin.tenant.open.infrastructures.criterias.CriteriaAbstract;
import com.bcxin.tenant.open.infrastructures.enums.PoliceEventCategory;
import com.bcxin.tenant.open.infrastructures.enums.PoliceEventLevel;
import com.bcxin.tenant.open.infrastructures.enums.PoliceEventStatus;
import lombok.Getter;

import java.util.Collection;

@Getter
public class PoliceIncidentsSearchCriteria extends CriteriaAbstract {
    private final PoliceEventLevel level;
    private final Collection<PoliceEventCategory> categories;
    private final PoliceEventStatus status;

    private final Collection<String> superviseDepartIds;

    private Collection<String> ids;

    public PoliceIncidentsSearchCriteria(
            int pageIndex, int pageSize,

            Collection<String> superviseDepartIds,
            PoliceEventLevel level,
                                         PoliceEventStatus status,
                                         Collection<PoliceEventCategory> categories) {
        super(pageIndex,pageSize);
        this.superviseDepartIds = superviseDepartIds;
        this.level = level;
        this.categories = categories;
        this.status = status;
    }

    public static PoliceIncidentsSearchCriteria create(
            int pageIndex, int pageSize,

            Collection<String> superviseDepartIds,
            PoliceEventLevel level,
                                                       PoliceEventStatus status,
                                                       Collection<PoliceEventCategory> categories) {
        return new PoliceIncidentsSearchCriteria(pageIndex,pageSize, superviseDepartIds,level, status, categories);
    }
}
