package com.bcxin.tenant.open.document.domains.documents;

import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.ContentFollowType;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.repository.query.SearchLanguage;
import lombok.Data;
import org.springframework.data.annotation.Id;

@Document(language = SearchLanguage.CHINESE)
@Data
public class TenantContentFollowDocument  extends EntityAbstract implements Aggregate {
    @Id
    @Indexed
    private String businessId;

    /**
     * 对应数据库中的Id
     */
    private Long id;

    @Indexed
    private String followType;
    @Indexed
    private String contentFollowId;

    @Indexed
    private String followerId;


    public static TenantContentFollowDocument create(String businessId,
                                                     ContentFollowType followType,
                                                     String contentFollowId,
                                                     String followerId) {
        TenantContentFollowDocument document = new TenantContentFollowDocument();
        document.setBusinessId(businessId);
        document.setFollowType(followType.name());
        document.setContentFollowId(contentFollowId);
        document.setFollowerId(followerId);

        return document;
    }
}
