package com.bcxin.tenant.open.document.domains.documents;

import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.ExamType;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.repository.query.SearchLanguage;
import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.util.StringUtils;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Arrays;

/**
 * 考试信息
 */
@Document(language = SearchLanguage.CHINESE)
@Data
public class RdSystemExamInfoDocument   extends EntityAbstract {

    @Id
    @Indexed
    private String id;

    private String name;

    @Indexed
    private Long beginTimeOfTs;

    @Indexed
    private Long endTimeOfTs;

    private LocalDateTime beginTime;

    private LocalDateTime endTime;

    /**
     * 考试类型
     */
    private ExamType examType;

    /**
     * 选中的监考老师列表
     */
    private String teacherIds;

    /**
     * 关联的考场的Id
     */
    @Indexed
    private String examSiteRoomId;


    @Indexed
    private String superviseDepartId;

    @Indexed
    private String organizationId;

    private Timestamp lastSyncTime;

    public int getCountOfTeachers() {
        if (!StringUtils.hasLength(this.getTeacherIds())) {
            return 0;
        }

        return (int) Arrays.stream(this.getTeacherIds().split(";"))
                .filter(ii -> StringUtils.hasLength(ii)).count();
    }
}
