package com.bcxin.tenant.open.document.domains.documents;

import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.redis.om.spring.annotations.*;
import com.redis.om.spring.repository.query.SearchLanguage;
import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.data.geo.Point;

import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Set;

/**
 * 考场信息
 */
@Document(language = SearchLanguage.CHINESE)
@Data
public class RdExamSiteRoomDocument  extends EntityAbstract implements Aggregate {

    /**
     * 考场Id
     */
    @Id
    @Indexed
    private String id;

    /**
     * 考场名称
     */
    @Searchable(sortable = false, nostem = true, weight = 20.0)
    private String name;

    /**
     * 经纬度
     */
    @Indexed
    @GeoIndexed
    private Point lonLat;

    /**
     * 考试点Id
     */
    @Indexed
    private String examSiteId;

    /**
     * 考试点名称
     */
    private String examSiteName;

    /**
     * 容纳的人员数量
     */
    private int capacityOfPerson;

    /**
     * 有效范围
     */
    private String scopeRange;

    /**
     * 考场状态
     * true: 启用
     * false: 禁用
     */
    @Indexed
    private boolean status;

    /**
     * 监管归属Id
     */
    @Indexed
    private String superviseDepartId;

    private String superviseDepartName;

    /**
     * 关注
     */
    @Indexed
    @TagIndexed
    private Set<String> followedDeviceNos;

    private Timestamp lastSyncTime;

    private String companyName;

    @Indexed
    private String organizationId;

    private Boolean hasVideo;

    public boolean addFollowedDeviceNo(String deviceNo) {
        Set<String> followedDeviceNos = this.getFollowedDeviceNos();
        if (followedDeviceNos == null) {
            followedDeviceNos = new HashSet<>();
        }

        boolean flag = followedDeviceNos.add(deviceNo);

        this.setFollowedDeviceNos(followedDeviceNos);

        return flag;
    }

    public boolean removeFollowedDeviceNo(String deviceNo) {
        Set<String> followedDeviceNos = this.getFollowedDeviceNos();
        if (followedDeviceNos == null) {
            followedDeviceNos = new HashSet<>();
        }

        boolean flag = followedDeviceNos.remove(deviceNo);

        this.setFollowedDeviceNos(followedDeviceNos);

        return flag;
    }
}
