package com.bcxin.tenant.open.document.domains.documents;

import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.annotations.GeoIndexed;
import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.annotations.Searchable;
import com.redis.om.spring.repository.query.SearchLanguage;
import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.data.geo.Point;

import java.sql.Timestamp;

/**
 * 考试点
 */
@Document(language = SearchLanguage.CHINESE)
@Data
public class RdExamSiteDocument  extends EntityAbstract implements Aggregate {

    @Id
    @Indexed
    private String id;

    /**
     * 考点名称
     */
    @Searchable(nostem = true)
    private String name;

    /**
     * 企业Id
     */
    @Indexed
    private String organizationId;

    /**
     * 所属企业
     */
    private String companyName;

    /**
     * 考试点地址
     */
    private String address;

    /**
     * 考试数量
     */
    private int countOfRoom;

    /**
     * 容纳的人员数量
     */
    private int capacityOfPerson;

    /**
     * 经纬度
     */
    @Indexed
    @GeoIndexed
    private Point lonLat;

    /**
     * 考试点状态
     * true: 启用
     * false: 禁用
     */
    @Indexed
    private boolean status;

    /**
     * 监管归属Id
     */
    @Indexed
    private String superviseDepartId;

    /**
     * 所在地区
     */
    private String region;


    private String superviseDepartName;

    private Timestamp lastSyncTime;
}