package com.bcxin.tenant.open.document.domains.documents;

import com.bcxin.tenant.open.infrastructures.constants.BusinessConstants;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.*;
import com.bcxin.tenant.open.infrastructures.utils.SetUtil;
import com.bcxin.tenant.open.infrastructures.valueTypes.LocationAddressValueType;
import com.redis.om.spring.annotations.*;
import com.redis.om.spring.repository.query.SearchLanguage;
import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.data.geo.Point;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.*;
import java.util.stream.Collectors;


/**
 * 企业-职员信息及企业-驻勤基本快照信息
 */
@Document(language = SearchLanguage.CHINESE)
@Data
public class RdEmployeeDocument extends EntityAbstract implements Aggregate {

    @Id
    @Indexed
    private String id;

    @Indexed
    private String name;

    @Indexed
    private String idCardNo;

    private CommunicatedType communicatedType;

    private int yardmanType;

    private String headPhoto;

    private String contact;

    @Indexed
    private String companyName;

    private EmploymentStatus status;

    private UserCheckedStatus checkedStatus;

    private RealNameAuthenticatedStatus authenticatedStatus;

    @Indexed
    private String dutyStatus;

    private String militaryStatus;

    private String securityCertificateNo;

    @Indexed
    @TagIndexed
    private Set<String> followedDeviceNos;

    @Indexed
    @GeoIndexed
    private Point lonLat;

    public LocationAddressValueType geoAddress;

    @Indexed
    private OccupationType occupationType;

    private Date hiredDate;

    private boolean insure;

    @Indexed
    private String organizationId;

    @Indexed
    private String tenantUserId;

    private String tenantEmployeeId;

    @Indexed
    private String superviseDepartId;

    private String superviseDepartName;

    private String deviceNumber;

    private String tenantImUserId;

    @Indexed
    private String securityStationId;
    @Indexed
    private String securityStationName;

    @Indexed
    private Set<String> stationTypes;

    /**
     * 权限范围
     * 监管属性, 本企业, 内保单位, 内保主管单位
     */
    @Indexed
    private Set<String> scopePermissions;

    @Indexed
    private Boolean dispatchable;

    private String superviseRegionCode;

    private String cId;

    private Set<String> securityStationRailIds;

    private Sex sex;

    /**
     * 驻勤点负责人
     * todo: 相关承办单位需要能够管理相关驻勤点信息
     */
    private Set<String> responsibleOfStationIds;

    private boolean domainAdmin;

    /**
     * 资源类型: 保安,社会力量,内保单位
     */
    @Indexed
    private Set<String> resourceTypes;

    /**
     * 企业的行业类型
     */
    private String industry;

    /**
     * 企业的机构类型
     */
    private String institutional;

    /**
     * 所属内保单位
     */
    private String proprietorCompanyName;

    private String proprietorCompanyId;

    private Timestamp lastUpdatedTime;

    private Timestamp lastDutyStatusChangedTime;

    /**
     * 公司的级别: 集团，高级企业或者企业
     * 这边原本的设计是按照拥有多个级别的功能来设计的
     */
    private int cLevel;

        /**
     * 负责的考试点Ids
     */
    private Set<String> examSiteId;

    private String thirdParty;

    private Integer countOfStation;

    /**
     * 支付企业
     */
    private String paymentOrgId;

    public void addScopePermissions(String... scopeIds) {
        this.setScopePermissions(SetUtil.merge(this.getScopePermissions(), scopeIds));
    }

    /**
     * 相关的内保单位
     *
     * @param companyId
     * @param companyName
     */
    public void assignProprietor(String companyId, String companyName) {
        this.setProprietorCompanyId(companyId);
        this.setProprietorCompanyName(companyName);
    }

    private static final String INCORRECT_NOTE = "漏洞:";

    public void removeBusinessScopePermissions(String... scopeIds) {
        this.setScopePermissions(SetUtil.remove(this.getScopePermissions(), scopeIds));
        this.setScopePermissions(SetUtil.merge(this.getScopePermissions(), this.getOrganizationId(), this.getSuperviseDepartId()));
    }

    public boolean hasMatchedStationRailMessage(String railId) {
        if (!StringUtils.hasLength(railId)) {
            return true;
        }

        if (this.getSecurityStationRailIds() == null || this.getSecurityStationRailIds().size() == 0) {
            return false;
        }

        return this.getSecurityStationRailIds().contains(railId);
    }

    public void addStationRailMessage(String railId) {
        if (!StringUtils.hasLength(railId)) {
            return;
        }

        Set<String> railIds = this.getSecurityStationRailIds();
        if (this.getSecurityStationRailIds() == null) {
            railIds = new HashSet<>();
        }

        railIds.add(railId);

        this.setSecurityStationRailIds(railIds);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
    }

    public void removeFromStationRailMessage(String railId) {
        if (!StringUtils.hasLength(railId)) {
            return;
        }

        Set<String> railIds = this.getSecurityStationRailIds();
        if (this.getSecurityStationRailIds() == null) {
            return;
        }

        railIds.remove(railId);

        this.setSecurityStationRailIds(railIds);
    }

    public void changeDutyStatus(RecordStatus status, Point lonLat) {
        switch (status) {
            case SignIn -> {
                this.setDutyStatus(DutySignInType.SignIn.name());
                makeDispatchable(true, null);
                this.setLastDutyStatusChangedTime(Timestamp.from(Instant.now()));
            }
            case SignOut -> {
                this.setDutyStatus(DutySignInType.SignOut.name());
                makeDispatchable(false, null);
                this.setLastDutyStatusChangedTime(Timestamp.from(Instant.now()));
            }
        }

        this.changeLonLat(lonLat);
    }

    public void changeLonLat(Point lonLat) {
        /**
         * 针对无效的经纬度, 我们将不在保存
         */
        if (lonLat != null) {
            this.setLonLat(lonLat);
            this.setLastDutyStatusChangedTime(Timestamp.from(Instant.now()));
        }
    }

    public void makeDispatchable(boolean dispatchable,String message) {
        this.setDispatchable(dispatchable);
        /*
        if (this.getDutySignInEnumType() == DutySignInType.SignIn) {
            this.setDispatchable(dispatchable);
        } else {
            this.setDispatchable(dispatchable);
        }

         */
        /*
        else {
            this.setSyncNote(String.format("预期=%s(dutyStatus=%s)(msg=%s);非签到状态不更新在岗离岗数据", dispatchable, this.getDutySignInEnumType(), message));
        }
         */
    }

    public void changeDeviceNumber(String deviceNumber) {
        this.setDeviceNumber(deviceNumber);
    }

    public boolean addFollowedDeviceNo(String deviceNo) {
        this.setFollowedDeviceNos(SetUtil.merge(this.getFollowedDeviceNos(), deviceNo));

        return true;
    }

    public boolean removeFollowedDeviceNo(String deviceNo) {
        this.setFollowedDeviceNos(SetUtil.remove(this.getFollowedDeviceNos(), deviceNo));

        return true;
    }

    public DutySignInType getDutySignInEnumType() {
        if (!StringUtils.hasLength(this.getDutyStatus())) {
            return null;
        }

        switch (this.getDutyStatus()) {
            case "SignIn" -> {
                return DutySignInType.SignIn;
            }
            case "SignOut" -> {
                return DutySignInType.SignOut;
            }
            case "None" -> {
                return DutySignInType.None;
            }
        }

        return null;
    }

    public void addResourceTypes(String... resourceTypes) {
        this.setResourceTypes(SetUtil.merge(this.getResourceTypes(), resourceTypes));
    }

    public void addResponsibleOfStationIds(String stationId) {
        if (StringUtils.hasLength(stationId)) {
            String[] stationIds = stationId.split(";|,");
            this.setResponsibleOfStationIds(SetUtil.merge(this.getResponsibleOfStationIds(), stationIds));
        }
    }

    public void rest() {
        this.setResponsibleOfStationIds(new HashSet<>());
        this.setSuperviseDepartId(BusinessConstants.DefaultEmptyValue);
        this.setScopePermissions(new HashSet<>());
        this.setResourceTypes(new HashSet<>());
        this.setProprietorCompanyName(null);
        this.setProprietorCompanyId(null);
    }

    public String getSelectedResponsibleOfStationId(String stationId) {
        if (!StringUtils.hasLength(stationId) ||
                CollectionUtils.isEmpty(this.getResponsibleOfStationIds())) {
            return BusinessConstants.DefaultEmptyValue;
        }

        return this.getResponsibleOfStationIds().contains(stationId) ? stationId : BusinessConstants.DefaultEmptyValue;
    }

    public void updateCountOfStations(int countOfStation) {
        this.setCountOfStation(countOfStation);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
    }
}
