package com.bcxin.tenant.open.rest.apis.utils;

import com.bcxin.tenant.open.infrastructures.KeyValueConstants;
import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.infrastructures.exceptions.BadTenantException;
import com.bcxin.tenant.open.infrastructures.exceptions.UnAuthorizedTenantException;
import com.bcxin.tenant.open.infrastructures.UserDetailResponse;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.util.StringUtils;

import java.util.Map;

public class ServletRequestUtil {
    private static final String AUTHENTICATION="Authorization";
    public static final String EMPLOYEE_AUTHENTICATION="dispatchToken";//""employee_token";
    public static final String EMPLOYEE_ACCESSTOKEN="accessToken";//""employee_token";

    public static final String HEADER_TRAFFIC_TAG="TRAFFIC_TAG";//""employee_token";
    public static final String HEADER_BCX_EMP_ID="bcx-emp-id";//""employee_token";

    public static String getBearerToken(ServletRequest servletRequest) {
        HttpServletRequest request = (HttpServletRequest) servletRequest;
        String authentication = request.getHeader(AUTHENTICATION);

        if (!StringUtils.hasLength(authentication)) {
            return null;
        }

        if (!authentication.contains("Bearer ")) {
            return null;
        }

        return authentication.substring(7);
    }

    public static String getDispatchToken(ServletRequest servletRequest) {
        return getValueFromHeader(servletRequest, EMPLOYEE_AUTHENTICATION,false);
    }

    public static String getAccessToken(ServletRequest servletRequest) {
        return getValueFromHeader(servletRequest, EMPLOYEE_ACCESSTOKEN,false);
    }

    public static String getValueFromHeader(ServletRequest servletRequest,String headName,boolean skipParams)
    {
        HttpServletRequest request = (HttpServletRequest) servletRequest;
        String headerValue = request.getHeader(headName);

        if (!skipParams && !StringUtils.hasLength(headerValue)) {
            Map<String, String[]> parameterMap = request.getParameterMap();
            if (parameterMap != null) {
                String[] tokens = parameterMap.get(headName);
                if (tokens != null && tokens.length > 0) {
                    return tokens[0];
                }
            }

            return null;
        }

        return headerValue;
    }

    public static String getIpAddress(HttpServletRequest servletRequest) {
        String skipIpAddressValidation =
                servletRequest.getParameter(KeyValueConstants.IGNORE_IP_ADDRESS_VALUE_PARAMETER_NAME);
        if ("1".equalsIgnoreCase(skipIpAddressValidation)) {
            return KeyValueConstants.IGNORE_IP_ADDRESS_VALUE;
        }

        if ("1".equalsIgnoreCase(servletRequest.getHeader(KeyValueConstants.IGNORE_IP_ADDRESS_VALUE_PARAMETER_NAME))) {
            return KeyValueConstants.IGNORE_IP_ADDRESS_VALUE;
        }

        String ipAddress = servletRequest.getHeader(KeyValueConstants.HEADER_X_FORWARD_FOR);
        if (!StringUtils.hasLength(ipAddress)) {
            ipAddress = servletRequest.getHeader(KeyValueConstants.HEADER_X_REAL_FOR);
        } else {
            return ipAddress;
        }

        if (!StringUtils.hasLength(ipAddress)) {
            ipAddress = servletRequest.getHeader(KeyValueConstants.HEADER_X_REAL_FOR);
        } else {
            return ipAddress;
        }

        if (!StringUtils.hasLength(ipAddress))
        {
            return servletRequest.getRemoteHost();
        }else {
            return ipAddress;
        }
        /*
        StringBuilder sb = new StringBuilder();
        Enumeration<String> headerNames = servletRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String hName = headerNames.nextElement();
            sb.append(String.format("%s=%s;", hName, servletRequest.getHeader(hName)));
        }

        sb.append(servletRequest.getRemoteHost());

        return sb.toString();

         */
    }

    public static UserDetailResponse extractUserDetail(JsonProvider jsonProvider, ServletRequest servletRequest) {
        String dispatchToken =null;
        try {
             dispatchToken = ServletRequestUtil.getDispatchToken(servletRequest);
            String content = JwtUtil.getUserIdFromToken(dispatchToken);
            UserDetailResponse userDetailResponse =
                    jsonProvider.toObject(UserDetailResponse.class, content);

            return userDetailResponse;
        } catch (Exception ex) {
            throw new BadTenantException(String.format("通过dispatchToken获取当前用户信息失败:dispatchToken=%s;error=%s", dispatchToken, ex));
        }}
}