package com.bcxin.tenant.open.rest.apis.utils;

import com.bcxin.tenant.open.infrastructures.enums.DispatchAccountType;
import com.bcxin.tenant.open.infrastructures.utils.BusinessUtil;
import com.bcxin.tenant.open.jdks.OrgPurseRpcProvider;
import com.bcxin.tenant.open.jdks.requests.OrgPursePointRequest;
import com.bcxin.tenant.open.jdks.responses.OrgPurseValidateResponse;
import com.bcxin.tenant.open.rest.apis.caches.CacheKeyManage;
import com.bcxin.tenant.open.rest.apis.caches.OrgPurseCache;
import com.bcxin.tenant.open.rest.apis.components.HotCacheProvider;
import com.bcxin.tenant.open.rest.apis.controllers.responses.ResponseBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

import java.util.Collection;
import java.util.stream.Collectors;

public class OrgPurseValidationUtil {
    public static ResponseEntity<ResponseBuilder.ResponseBody<OrgPurseValidateResponse>> doValidate(
            HotCacheProvider hotCacheProvider,
            OrgPurseRpcProvider orgPurseRpcProvider,
                                                                      DispatchAccountType accountType,
                                                                      String orgId) {

        OrgPurseCache orgPurseCache = hotCacheProvider.get(CacheKeyManage.getOrgPurseCacheKey(orgId), OrgPurseCache.class);
        OrgPurseValidateResponse validateResponse = null;
        if (orgPurseCache == null) {
            validateResponse = orgPurseRpcProvider.validate(OrgPursePointRequest.create(orgId));

            if (validateResponse != null) {
                Collection<OrgPurseCache.OrgPurseItemCache> orgPurseItemCaches
                        = validateResponse.getOrgPurseItems().stream()
                        .map(ix -> OrgPurseCache.OrgPurseItemCache.create(ix.getOrganizationId(), ix.isDispatchable()))
                        .collect(Collectors.toList());

                orgPurseCache = OrgPurseCache.create(orgPurseItemCaches);

                hotCacheProvider.put(CacheKeyManage.getOrgPurseCacheKey(orgId), 30 * 60, orgPurseCache, false);
            }
        }

        if (orgPurseCache != null) {
            validateResponse = OrgPurseValidateResponse.create(
                    orgPurseCache.getOrgPurseItems().stream().map(ix ->
                            OrgPurseValidateResponse.OrgPurseItemResponse.create(ix.getOrganizationId(), ix.isDispatchable())
                    ).collect(Collectors.toList())
            );
        }

        if (validateResponse == null || !validateResponse.IsDispatchable(orgId)) {
            if (BusinessUtil.checkIfDesk(accountType)) {
                return ResponseBuilder.build(HttpStatus.FORBIDDEN, validateResponse, "您尚未购买当前应用商品，请前往商城应用市场购买“调度台”与“联动值”商品后，方可进行调度操作");
            } else {
                return ResponseBuilder.build(HttpStatus.FORBIDDEN, validateResponse, String.format("请联系企业(%s)管理员购买联动值",orgId));
            }
        }

        return ResponseBuilder.build(HttpStatus.OK, validateResponse);
    }
}
