package com.bcxin.tenant.open.rest.apis.impls;

import com.bcxin.tenant.open.infrastructures.enums.DeskType;
import com.bcxin.tenant.open.infrastructures.enums.DispatchAccountType;
import com.bcxin.tenant.open.jdks.HotCacheRpcProvider;
import com.bcxin.tenant.open.jdks.requests.HotCacheRequest;
import com.bcxin.tenant.open.rest.apis.caches.CacheKeyManage;
import com.bcxin.tenant.open.rest.apis.components.HotCacheProvider;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;

@DubboService
public class HotCacheRpcProviderImpl implements HotCacheRpcProvider {
    private static final Logger logger = LoggerFactory.getLogger(HotCacheRpcProviderImpl.class);
    private final HotCacheProvider hotCacheProvider;

    public HotCacheRpcProviderImpl(HotCacheProvider hotCacheProvider) {
        this.hotCacheProvider = hotCacheProvider;
    }

    @Override
    public void refresh(HotCacheRequest request) {
        switch (request.getCategory()) {
            case Employee -> {
                Collection<String> cacheKeys = request.getIds().stream().flatMap(ix -> {
                    Collection<String> keys = new ArrayList<>();
                    keys.add(CacheKeyManage.getUserInfoFromAuthFilterKey(ix, DeskType.Normal));
                    keys.add(CacheKeyManage.getEmpDetailKey(ix));
                    keys.add(CacheKeyManage.getUserCurrentDutyStatus(ix));
                    keys.add(CacheKeyManage.getHotEmployeeStationId(ix));

                    keys.add(CacheKeyManage.getEmpDeskPermissionKey(ix, DispatchAccountType.APP));
                    keys.add(CacheKeyManage.getEmpDeskPermissionKey(ix, DispatchAccountType.Desk));
                    keys.add(CacheKeyManage.getEmpDeskPermissionKey(ix, DispatchAccountType.AppDesk));
                    return keys.stream();
                }).collect(Collectors.toList());

                this.hotCacheProvider.delete(cacheKeys);
            }
            case Organization -> {
                Collection<String> cacheKeys = request.getIds().stream().flatMap(ix -> {
                    Collection<String> keys = new ArrayList<>();
                    keys.add(CacheKeyManage.getOrgBasicKey(ix));
                    keys.add(CacheKeyManage.getOrgPurseCacheKey(ix));
                    return keys.stream();
                }).collect(Collectors.toList());

                this.hotCacheProvider.delete(cacheKeys);
            }
            case OrgPurse -> {
                Collection<String> cacheKeys = request.getIds().stream().flatMap(ix -> {
                    Collection<String> keys = new ArrayList<>();
                    keys.add(CacheKeyManage.getOrgPurseCacheKey(ix));
                    return keys.stream();
                }).collect(Collectors.toList());

                this.hotCacheProvider.delete(cacheKeys);
            }
            case Station -> {
                Collection<String> cacheKeys = request.getIds().stream().flatMap(ix -> {
                    Collection<String> keys = new ArrayList<>();
                    keys.add(CacheKeyManage.getHotAttStationBasicKey(ix));
                    return keys.stream();
                }).collect(Collectors.toList());

                this.hotCacheProvider.delete(cacheKeys);
            }
            case DispatchDataSource -> {
                Collection<String> cacheKeys = request.getIds().stream().flatMap(ix -> {
                    Collection<String> keys = new ArrayList<>();
                    keys.add(CacheKeyManage.getDispatchDataSourceKey(ix));
                    return keys.stream();
                }).collect(Collectors.toList());

                this.hotCacheProvider.delete(cacheKeys);
            }
        }
    }
}
