package com.bcxin.tenant.open.rest.apis.controllers.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;

@Schema(name = "ProjectAdvanceSearchResponse",title = "业务管理-项目信息")
@Getter
public class ProjectAdvanceSearchResponse extends ResponseAbstract {

    private final Long pkId;

    @Schema(name = "id", title = "id")
    private final String id;
    @Schema(name = "name", title = "项目名称")
    private final String name;
    @Schema(name = "statusLabel", title = "项目状态")
    private final String statusLabel;

    @Schema(name = "beginDate", title = "项目开始时间")
    private final String beginDate;

    @Schema(name = "endDate", title = "项目结束时间")
    private final String endDate;

    @Schema(name = "principalName", title = "项目负责人")
    private final String principalName;

    @Schema(name = "address", title = "项目详情地址")
    private final String address;

    @Schema(name = "countOfMembers", title = "项目成员数")
    private final int countOfMembers;

    @Schema(name = "countOfTeams", title = "岗点小组数")
    private final int countOfTeams;

    @Schema(name = "countOfStations", title = "岗垫小组数")
    private final int countOfStations;

    public ProjectAdvanceSearchResponse(Long pkId, String id, String name,
                                        Date beginDate, Date endDate,
                                        String principalName, String address,
                                        int countOfMembers, int countOfTeams,
                                        int countOfStations) {
        SimpleDateFormat dataFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        this.pkId = pkId;
        this.id = id;
        this.name = name;
        this.beginDate = dataFormat.format(beginDate);
        this.endDate = dataFormat.format(endDate);
        this.principalName = principalName;
        this.address = address;
        this.countOfMembers = countOfMembers;
        this.countOfTeams = countOfTeams;
        this.countOfStations = countOfStations;

        String label = "正常";
        var now = Timestamp.from(Instant.now());
        if (endDate.before(now)) {
            label = "已结束";
        } else if (beginDate.before(now)) {
            label = "未开始";
        }

        this.statusLabel = label;
    }
}
